/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.system;

import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.prefixes.PrefixMapI;
import org.apache.jena.dboe.storage.prefixes.PrefixesFactory;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixMap;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixesView;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;

public class GraphViewStorage
extends GraphView {
    private final StoragePrefixMap prefixes;

    public static GraphView createDefaultGraphStorage(DatasetGraph dsg, StoragePrefixes prefixes) {
        return new GraphViewStorage(dsg, Quad.defaultGraphNodeGenerated, prefixes);
    }

    public static GraphView createNamedGraphStorage(DatasetGraph dsg, Node graphIRI, StoragePrefixes prefixes) {
        return new GraphViewStorage(dsg, graphIRI, prefixes);
    }

    public static GraphView createUnionGraphStorage(DatasetGraph dsg, StoragePrefixes prefixes) {
        return new GraphViewStorage(dsg, Quad.unionGraph, prefixes);
    }

    protected GraphViewStorage(DatasetGraph dataset, Node graphName, StoragePrefixes prefixes) {
        super(dataset, graphName);
        this.prefixes = StoragePrefixesView.viewGraph(prefixes, graphName);
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        PrefixMapI x = PrefixesFactory.newPrefixMap(this.prefixes);
        PrefixMapping pm = PrefixesFactory.newPrefixMappingOverPrefixMapI(x);
        return pm;
    }

    @Override
    public void clear() {
        Node gn = this.getGraphName();
        if (gn == null) {
            gn = Quad.defaultGraphNodeGenerated;
        }
        this.getDataset().deleteAny(gn, Node.ANY, Node.ANY, Node.ANY);
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }
}

