/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.exec;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.exec.TripleValidator;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.validation.ReportItem;

public class ValidationStream
extends StreamRDFWrapper {
    private ValidationContext vCxt;
    private Collection<TripleValidator> validators;
    private final Set<Node> predicates = new HashSet<Node>();

    public ValidationStream(ValidationContext vCxt, Collection<TripleValidator> validators, StreamRDF dest) {
        super(dest);
        this.vCxt = vCxt;
        this.validators = validators;
        validators.stream().filter(v -> ShLib.isImmediate(v.getTarget())).map(v -> v.getTarget()).forEach(t -> this.predicates.add(t.getObject()));
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void triple(Triple triple) {
        if (!this.predicates.contains(triple.getPredicate())) {
            return;
        }
        for (TripleValidator validator : this.validators) {
            ReportItem item = validator.validate(this.vCxt, triple);
            if (item == null) continue;
            this.vCxt.reportEntry(item, validator, triple);
        }
    }

    @Override
    public void finish() {
        super.finish();
    }
}

