/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.function.Consumer;
import org.apache.jena.atlas.lib.tuple.TConsumer3;
import org.apache.jena.atlas.lib.tuple.TConsumer4;
import org.apache.jena.atlas.lib.tuple.TFunction3;
import org.apache.jena.atlas.lib.tuple.TFunction4;
import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.mem.TupleTable;

public abstract class OrderedTupleTable<TupleType, ConsumerType>
implements TupleTable<TupleType> {
    protected final TupleMap order;
    protected final TupleMap reverse;

    public OrderedTupleTable(TupleMap order) {
        this.order = order;
        this.reverse = order.reverse();
    }

    protected abstract ConsumerType add();

    protected abstract ConsumerType delete();

    protected Consumer<Quad> map(TConsumer4<Node> consumer) {
        return q -> {
            Node g = q.getGraph();
            Node s = q.getSubject();
            Node p = q.getPredicate();
            Node o = q.getObject();
            Node x1 = OrderedTupleTable.get(this.order.mapIdx(0), g, s, p, o);
            Node x2 = OrderedTupleTable.get(this.order.mapIdx(1), g, s, p, o);
            Node x3 = OrderedTupleTable.get(this.order.mapIdx(2), g, s, p, o);
            Node x4 = OrderedTupleTable.get(this.order.mapIdx(3), g, s, p, o);
            consumer.accept(x1, x2, x3, x4);
        };
    }

    protected <X> TFunction4<Node, X> map(TFunction4<Node, X> f) {
        return (g, s, p, o) -> OrderedTupleTable.apply(this.order, g, s, p, o, f);
    }

    protected Quad unmap(Node x1, Node x2, Node x3, Node x4) {
        return OrderedTupleTable.apply(this.reverse, x1, x2, x3, x4, Quad::new);
    }

    protected Consumer<Triple> map(TConsumer3<Node> consumer) {
        return t -> {
            Node s = t.getSubject();
            Node p = t.getPredicate();
            Node o = t.getObject();
            Node x1 = OrderedTupleTable.get(this.order.mapIdx(0), s, p, o);
            Node x2 = OrderedTupleTable.get(this.order.mapIdx(1), s, p, o);
            Node x3 = OrderedTupleTable.get(this.order.mapIdx(2), s, p, o);
            consumer.accept(x1, x2, x3);
        };
    }

    protected <T, X> TFunction3<T, X> map(TFunction3<T, X> f) {
        return (s, p, o) -> OrderedTupleTable.apply(this.order, s, p, o, f);
    }

    protected Triple unmap(Node x1, Node x2, Node x3) {
        return OrderedTupleTable.apply(this.reverse, x1, x2, x3, Triple::new);
    }

    private static <X> X get(int i, X x1, X x2, X x3) {
        switch (i) {
            case 0: {
                return x1;
            }
            case 1: {
                return x2;
            }
            case 2: {
                return x3;
            }
        }
        throw new IndexOutOfBoundsException("Triples have components 0, 1, 2 but index = " + i + "!");
    }

    private static <X> X get(int i, X x1, X x2, X x3, X x4) {
        switch (i) {
            case 0: {
                return x1;
            }
            case 1: {
                return x2;
            }
            case 2: {
                return x3;
            }
            case 3: {
                return x4;
            }
        }
        throw new IndexOutOfBoundsException("Quads have components 0, 1, 2, 3 but index = " + i + "!");
    }

    private static <X, Z> Z apply(TupleMap tupleMap, X x1, X x2, X x3, X x4, TFunction4<X, Z> f) {
        X x1a = OrderedTupleTable.get(tupleMap.mapIdx(0), x1, x2, x3, x4);
        X x2a = OrderedTupleTable.get(tupleMap.mapIdx(1), x1, x2, x3, x4);
        X x3a = OrderedTupleTable.get(tupleMap.mapIdx(2), x1, x2, x3, x4);
        X x4a = OrderedTupleTable.get(tupleMap.mapIdx(3), x1, x2, x3, x4);
        return f.apply(x1a, x2a, x3a, x4a);
    }

    private static <X, Z> Z apply(TupleMap ordering, X x1, X x2, X x3, TFunction3<X, Z> f) {
        X x1a = OrderedTupleTable.get(ordering.mapIdx(0), x1, x2, x3);
        X x2a = OrderedTupleTable.get(ordering.mapIdx(1), x1, x2, x3);
        X x3a = OrderedTupleTable.get(ordering.mapIdx(2), x1, x2, x3);
        return f.apply(x1a, x2a, x3a);
    }
}

