/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Intersection;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.DyadicDatasetGraph;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class IntersectionDatasetGraph
extends DyadicDatasetGraph {
    public IntersectionDatasetGraph(DatasetGraph left, DatasetGraph right, Context c) {
        super(left, right, c);
    }

    Graph intersect(Function<DatasetGraph, Graph> op) {
        return this.apply(IntersectionView::new, op);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.intersect(DatasetGraph::getDefaultGraph);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return this.intersect(dsg -> dsg.getGraph(graphNode));
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.both(dsg -> dsg.containsGraph(graphNode) && !dsg.getGraph(graphNode).isEmpty());
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return Iter.iter(((DatasetGraph)this.getLeft()).listGraphNodes()).filter(((DatasetGraph)this.getRight())::containsGraph);
    }

    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        return this.both(dsg -> dsg.contains(g, s, p, o));
    }

    static class IntersectionView
    extends Intersection {
        public IntersectionView(Graph L, Graph R) {
            super(L, R);
        }

        @Override
        public void performAdd(Triple t) {
            DyadicDatasetGraph.throwNoMutationAllowed();
        }

        @Override
        public void performDelete(Triple t) {
            DyadicDatasetGraph.throwNoMutationAllowed();
        }

        @Override
        public void clear() {
            DyadicDatasetGraph.throwNoMutationAllowed();
        }

        @Override
        protected ExtendedIterator<Triple> _graphBaseFind(Triple s) {
            return this.L.isEmpty() || this.R.isEmpty() ? NullIterator.instance() : super._graphBaseFind(s);
        }
    }
}

