/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.nodetable;

import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.tdb2.TDBException;

public class ThreadBufferingCache<Key, Value>
implements Cache<Key, Value> {
    private final Cache<Key, Value> localCache;
    private final Cache<Key, Value> baseCache;
    private final AtomicReference<Thread> bufferingThread = new AtomicReference();
    private Object lock = new Object();
    private String label;
    private static final boolean BUFFERING = true;

    public ThreadBufferingCache(String label, Cache<Key, Value> mainCache, int size) {
        this.localCache = CacheFactory.createCache(size);
        this.baseCache = mainCache;
        this.label = label;
    }

    private boolean buffering() {
        if (this.bufferingThread == null) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        return this.bufferingThread.get() == currentThread;
    }

    private Cache<Key, Value> localCache() {
        return this.localCache;
    }

    public void enableBuffering() {
        Thread thread = Thread.currentThread();
        boolean b = this.bufferingThread.compareAndSet(null, thread);
        if (!b) {
            throw new TDBException(Lib.className(this) + ": already buffering");
        }
    }

    public void flushBuffer() {
        if (!this.buffering()) {
            return;
        }
        this.localCache().keys().forEachRemaining(k -> {
            Value value = this.localCache().getIfPresent(k);
            this.baseCache.put(k, value);
        });
        this.localCache().clear();
        this.bufferingThread.set(null);
    }

    public void dropBuffer() {
        if (!this.buffering()) {
            return;
        }
        this.localCache().clear();
        this.bufferingThread.set(null);
    }

    public Cache<Key, Value> getBuffer() {
        return this.localCache();
    }

    public Cache<Key, Value> getBaseCache() {
        return this.baseCache;
    }

    @Override
    public boolean containsKey(Key key) {
        if (!this.buffering()) {
            return this.baseCache.containsKey(key);
        }
        return this.localCache().containsKey(key) || this.baseCache.containsKey(key);
    }

    @Override
    public Value getIfPresent(Key key) {
        if (!this.buffering()) {
            return this.baseCache.getIfPresent(key);
        }
        Value item = this.localCache().getIfPresent(key);
        if (item != null) {
            return item;
        }
        return this.baseCache.getIfPresent(key);
    }

    @Override
    public Value getOrFill(Key key, Callable<Value> callable) {
        if (!this.buffering()) {
            return this.baseCache.getOrFill(key, callable);
        }
        Value item = this.localCache().getIfPresent(key);
        if (item != null) {
            return item;
        }
        item = this.baseCache.getIfPresent(key);
        if (item != null) {
            return item;
        }
        try {
            item = callable.call();
            this.localCache().put(key, item);
        }
        catch (Exception ex) {
            throw new TDBException("Exception filling cache", ex);
        }
        return item;
    }

    @Override
    public void put(Key key, Value value) {
        if (!this.buffering()) {
            this.baseCache.put(key, value);
            return;
        }
        this.localCache().put(key, value);
    }

    @Override
    public void remove(Key key) {
        if (!this.buffering()) {
            this.baseCache.remove(key);
            return;
        }
        this.localCache().remove(key);
    }

    @Override
    public Iterator<Key> keys() {
        if (!this.buffering()) {
            return this.baseCache.keys();
        }
        return Iter.concat(this.localCache().keys(), this.baseCache.keys());
    }

    @Override
    public boolean isEmpty() {
        if (!this.buffering()) {
            return this.baseCache.isEmpty();
        }
        return this.localCache().isEmpty();
    }

    @Override
    public void clear() {
        if (!this.buffering()) {
            this.baseCache.clear();
            return;
        }
        this.localCache().clear();
    }

    @Override
    public long size() {
        if (!this.buffering()) {
            return this.baseCache.size();
        }
        return this.localCache().size();
    }

    @Override
    public void setDropHandler(BiConsumer<Key, Value> dropHandler) {
        if (!this.buffering()) {
            return;
        }
        this.localCache().setDropHandler(dropHandler);
    }
}

