/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.cli.io.options_digestion;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.vibe.cli.RunMode;
import org.molgenis.vibe.cli.io.options_digestion.VibeOptions;
import org.molgenis.vibe.cli.io.output.format.gene_prioritized.GenePrioritizedOutputFormatWriterFactory;
import org.molgenis.vibe.cli.properties.VibeProperties;
import org.molgenis.vibe.core.exceptions.InvalidStringFormatException;

public abstract class CommandLineOptionsParser {
    private static final String ARGUMENT_OPTIONS_FORMAT = "|%-12s%s%n";
    private static Options options = new Options();

    private CommandLineOptionsParser() {
    }

    public static VibeOptions parse(String[] args) throws ParseException {
        VibeOptions vibeOptions = new VibeOptions();
        CommandLineOptionsParser.parse(args, vibeOptions);
        return vibeOptions;
    }

    public static void parse(String[] args, VibeOptions vibeOptions) throws ParseException {
        CommandLine commandLine = CommandLineOptionsParser.parseCommandLine(args);
        CommandLineOptionsParser.digestCommandLine(commandLine, vibeOptions);
    }

    private static void createOptions() {
        options.addOption(Option.builder("h").longOpt("help").desc("Show help message.").build());
        options.addOption(Option.builder("v").longOpt("version").desc("Shows the application version.").build());
        options.addOption(Option.builder("d").longOpt("debug").desc("Shows debug information.").build());
        options.addOption(Option.builder("f").longOpt("force").desc("Overwrite output file if it already exists.").build());
        options.addOption(Option.builder("p").longOpt("phenotype").desc("A phenotype described using an HPO id. Must include the 'hp:' or 'HP:' prefix.").hasArg().argName("HPO ID").build());
        options.addOption(Option.builder("w").longOpt("ontology").desc("The Human Phenotype Ontology file (.owl). Can be given without -n or -m, but has no use then.").hasArg().argName("FILE").build());
        options.addOption(Option.builder("n").longOpt("ontology-algorithm").desc("The ontology algorithm to be used for related HPO retrieval:" + System.lineSeparator() + String.format(ARGUMENT_OPTIONS_FORMAT, "children", "Uses child algorithm.") + String.format(ARGUMENT_OPTIONS_FORMAT, "distance", "Uses distance algorithm.")).hasArg().argName("NAME").build());
        options.addOption(Option.builder("m").longOpt("ontology-max").desc("The maximum distance to be used for the ontology algorithm.").hasArg().argName("NUMBER").build());
        options.addOption(Option.builder("t").longOpt("hdt").desc("The HDT file containing the vibe database.").hasArg().argName("FILE").build());
        options.addOption(Option.builder("o").longOpt("output").desc("The file to write output to.").hasArg().argName("FILE").build());
        options.addOption(Option.builder("l").longOpt("simple-output").desc("Simple output format (file only contains separated gene symbols)").build());
        options.addOption(Option.builder("u").longOpt("uri").desc("Returns uri's instead of id's for certain output fields" + System.lineSeparator() + "(doesn't work in combination with -l).").build());
    }

    public static void printHelpMessage() {
        String cmdSyntax = "java -jar vibe-with-dependencies.jar [-h] [-v] [-d] [-f] -t <FILE> -w <FILE> [-n <NAME> -m <NUMBER>] [-o <FILE>] [-l] [-u] -p <HPO ID> [-p <HPO ID>]...";
        String helpHeader = "";
        String helpFooter = VibeProperties.APP_NAME.getValue() + " v" + VibeProperties.APP_VERSION.getValue();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(80, cmdSyntax, helpHeader, options, helpFooter, false);
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        return parser.parse(options, args);
    }

    private static void digestCommandLine(CommandLine commandLine, VibeOptions vibeOptions) throws InvalidPathException, ParseException, NumberFormatException, InvalidStringFormatException {
        CommandLineOptionsParser.defineRunMode(commandLine, vibeOptions);
        CommandLineOptionsParser.checkForMissingArguments(commandLine, vibeOptions);
        ArrayList<String> errors = new ArrayList<String>();
        switch (vibeOptions.getRunMode()) {
            case GENES_FOR_PHENOTYPES_WITH_ASSOCIATED_PHENOTYPES: {
                CommandLineOptionsParser.digestHpoOntologyArguments(commandLine, vibeOptions, errors);
            }
            case GENES_FOR_PHENOTYPES: {
                CommandLineOptionsParser.digestDatabases(commandLine, vibeOptions, errors);
                CommandLineOptionsParser.digestInputPhenotypes(commandLine, vibeOptions, errors);
                CommandLineOptionsParser.digestOutputArguments(commandLine, vibeOptions, errors);
            }
        }
        if (!errors.isEmpty()) {
            throw new ParseException(StringUtils.join(errors, System.lineSeparator()));
        }
    }

    private static void defineRunMode(CommandLine commandLine, VibeOptions vibeOptions) {
        if (commandLine.getOptions().length == 0 || commandLine.hasOption("h")) {
            vibeOptions.setRunMode(RunMode.HELP);
        } else if (commandLine.hasOption("v")) {
            vibeOptions.setRunMode(RunMode.VERSION);
        } else if (commandLine.hasOption("n") || commandLine.hasOption("m")) {
            vibeOptions.setRunMode(RunMode.GENES_FOR_PHENOTYPES_WITH_ASSOCIATED_PHENOTYPES);
        } else {
            vibeOptions.setRunMode(RunMode.GENES_FOR_PHENOTYPES);
        }
    }

    private static void checkForMissingArguments(CommandLine commandLine, VibeOptions vibeOptions) throws ParseException {
        String[] requiredArguments;
        if (vibeOptions.getRunMode() == RunMode.HELP || vibeOptions.getRunMode() == RunMode.VERSION) {
            return;
        }
        ArrayList<String> missing = new ArrayList<String>();
        for (String argument : requiredArguments = new String[]{"t", "w", "p"}) {
            if (commandLine.hasOption(argument)) continue;
            missing.add("-" + argument);
        }
        if (vibeOptions.getRunMode() == RunMode.GENES_FOR_PHENOTYPES_WITH_ASSOCIATED_PHENOTYPES) {
            if (!commandLine.hasOption("n")) {
                missing.add("-n");
            }
            if (!commandLine.hasOption("m")) {
                missing.add("-m");
            }
        }
        if (!missing.isEmpty()) {
            throw new ParseException("Missing arguments: " + StringUtils.join(missing, ", "));
        }
    }

    private static void digestDatabases(CommandLine commandLine, VibeOptions vibeOptions, List<String> errors) {
        try {
            vibeOptions.setVibeDatabase(commandLine.getOptionValue("t"));
        }
        catch (IOException | InvalidPathException e2) {
            errors.add(e2.getMessage());
        }
        try {
            vibeOptions.setHpoOntology(commandLine.getOptionValue("w"));
        }
        catch (IOException | InvalidPathException e3) {
            errors.add(e3.getMessage());
        }
    }

    private static void digestInputPhenotypes(CommandLine commandLine, VibeOptions vibeOptions, List<String> errors) {
        try {
            vibeOptions.setPhenotypes(commandLine.getOptionValues("p"));
        }
        catch (InvalidStringFormatException e2) {
            errors.add(e2.getMessage());
        }
    }

    private static void digestOutputArguments(CommandLine commandLine, VibeOptions vibeOptions, List<String> errors) {
        block9: {
            vibeOptions.setVerbose(commandLine.hasOption("d"));
            if (commandLine.hasOption("l")) {
                vibeOptions.setGenePrioritizedOutputFormatWriterFactory(GenePrioritizedOutputFormatWriterFactory.SIMPLE);
            } else if (commandLine.hasOption("u")) {
                vibeOptions.setGenePrioritizedOutputFormatWriterFactory(GenePrioritizedOutputFormatWriterFactory.REGULAR_URI);
            } else {
                vibeOptions.setGenePrioritizedOutputFormatWriterFactory(GenePrioritizedOutputFormatWriterFactory.REGULAR_ID);
            }
            if (commandLine.hasOption("o")) {
                try {
                    if (commandLine.hasOption("f")) {
                        vibeOptions.setFileOutputWriterForced(commandLine.getOptionValue("o"));
                        break block9;
                    }
                    vibeOptions.setFileOutputWriter(commandLine.getOptionValue("o"));
                }
                catch (FileAlreadyExistsException | InvalidPathException e2) {
                    errors.add(e2.getMessage());
                }
            } else {
                vibeOptions.setStdoutOutputWriter();
            }
        }
    }

    private static void digestHpoOntologyArguments(CommandLine commandLine, VibeOptions vibeOptions, List<String> errors) {
        try {
            vibeOptions.setPhenotypesRetrieverFactory(commandLine.getOptionValue("n"));
        }
        catch (EnumConstantNotPresentException e2) {
            errors.add(commandLine.getOptionValue("n") + " is not a valid HPO retrieval algorithm.");
        }
        try {
            vibeOptions.setOntologyMaxDistance(commandLine.getOptionValue("m"));
        }
        catch (IllegalArgumentException e3) {
            errors.add(commandLine.getOptionValue("m") + " is not a valid HPO retrieval algorithm distance (must be a number >= 0).");
        }
    }

    static {
        CommandLineOptionsParser.createOptions();
    }
}

