/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.molgenis.vibe.core.database_processing.GenesForPhenotypeRetriever;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.io.input.ModelReader;
import org.molgenis.vibe.core.io.input.VibeDatabase;

public class GeneDiseaseCollectionRetrievalRunner
implements Callable<GeneDiseaseCollection> {
    private VibeDatabase vibeDatabase;
    private Set<Phenotype> phenotypes;

    public GeneDiseaseCollectionRetrievalRunner(VibeDatabase vibeDatabase, Set<Phenotype> phenotypes) {
        this.vibeDatabase = Objects.requireNonNull(vibeDatabase);
        this.phenotypes = phenotypes;
    }

    @Override
    public GeneDiseaseCollection call() throws IOException {
        try (ModelReader modelReader = this.vibeDatabase.getModelReader();){
            GenesForPhenotypeRetriever genesForPhenotypeRetriever = new GenesForPhenotypeRetriever(modelReader, this.phenotypes);
            genesForPhenotypeRetriever.run();
            GeneDiseaseCollection geneDiseaseCollection = genesForPhenotypeRetriever.getGeneDiseaseCollection();
            return geneDiseaseCollection;
        }
    }
}

