/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.math3.util.Pair;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64BigDisk;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatCommon;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatIterator;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMapping;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMappingBack;
import org.rdfhdt.hdt.dictionary.impl.utilCat.IteratorPlusString;
import org.rdfhdt.hdt.dictionary.impl.utilCat.IteratorPlusStringComparator;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.ListenerUtil;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;

public class FourSectionDictionaryCat {
    private String location;
    private int DEFAULT_BLOCK_SIZE = 16;
    private int BLOCK_PER_BUFFER = 1000000;
    private long numShared;
    private CatMapping mappingSh1;
    private CatMapping mappingSh2;
    private CatMapping mappingS1;
    private CatMapping mappingS2;
    private CatMapping mappingO1;
    private CatMapping mappingO2;
    private CatMapping mappingP1;
    private CatMapping mappingP2;
    private CatMappingBack mappingS;

    public FourSectionDictionaryCat(String location) {
        this.location = location;
    }

    public void cat(Dictionary dictionary1, Dictionary dictionary2, ProgressListener listener) {
        System.out.println("PREDICATES-------------------");
        this.mappingP1 = new CatMapping(this.location, "P1", (int)dictionary1.getPredicates().getNumberOfElements());
        this.mappingP2 = new CatMapping(this.location, "P2", (int)dictionary2.getPredicates().getNumberOfElements());
        int numCommonPredicates = 0;
        CatCommon commonP1P2 = new CatCommon(dictionary1.getPredicates().getSortedEntries(), dictionary2.getPredicates().getSortedEntries());
        long maxPredicates = dictionary1.getPredicates().getNumberOfElements() + dictionary2.getPredicates().getNumberOfElements();
        while (commonP1P2.hasNext()) {
            commonP1P2.next();
            ++numCommonPredicates;
        }
        long numPredicates = dictionary1.getPredicates().getNumberOfElements() + dictionary2.getPredicates().getNumberOfElements() - (long)numCommonPredicates;
        this.catSection(numPredicates, 4, dictionary1.getPredicates(), dictionary2.getPredicates(), Collections.emptyList().iterator(), Collections.emptyList().iterator(), this.mappingP1, this.mappingP2, listener);
        System.out.println("SUBJECTS-------------------");
        CatIterator commonSubject1 = new CatIterator(new CatCommon(dictionary1.getSubjects().getSortedEntries(), dictionary2.getShared().getSortedEntries()), new CatCommon(dictionary1.getSubjects().getSortedEntries(), dictionary2.getObjects().getSortedEntries()));
        int numCommonSubject1Hdt2 = 0;
        while (commonSubject1.hasNext()) {
            commonSubject1.next();
            ++numCommonSubject1Hdt2;
        }
        CatIterator commonSubject2 = new CatIterator(new CatCommon(dictionary2.getSubjects().getSortedEntries(), dictionary1.getShared().getSortedEntries()), new CatCommon(dictionary2.getSubjects().getSortedEntries(), dictionary1.getObjects().getSortedEntries()));
        int numCommonSubject2Hdt1 = 0;
        while (commonSubject2.hasNext()) {
            commonSubject2.next();
            ++numCommonSubject2Hdt1;
        }
        int numCommonSubjects = 0;
        CatCommon commonS1S2 = new CatCommon(dictionary1.getSubjects().getSortedEntries(), dictionary2.getSubjects().getSortedEntries());
        while (commonS1S2.hasNext()) {
            commonS1S2.next();
            ++numCommonSubjects;
        }
        long numSubjects = dictionary1.getSubjects().getNumberOfElements() + dictionary2.getSubjects().getNumberOfElements() - (long)numCommonSubjects - (long)numCommonSubject1Hdt2 - (long)numCommonSubject2Hdt1;
        this.mappingS1 = new CatMapping(this.location, "S1", (int)dictionary1.getSubjects().getNumberOfElements());
        this.mappingS2 = new CatMapping(this.location, "S2", (int)dictionary2.getSubjects().getNumberOfElements());
        commonSubject1 = new CatIterator(new CatCommon(dictionary1.getSubjects().getSortedEntries(), dictionary2.getShared().getSortedEntries()), new CatCommon(dictionary1.getSubjects().getSortedEntries(), dictionary2.getObjects().getSortedEntries()));
        commonSubject2 = new CatIterator(new CatCommon(dictionary2.getSubjects().getSortedEntries(), dictionary1.getShared().getSortedEntries()), new CatCommon(dictionary2.getSubjects().getSortedEntries(), dictionary1.getObjects().getSortedEntries()));
        this.catSection(numSubjects, 2, dictionary1.getSubjects(), dictionary2.getSubjects(), commonSubject1, commonSubject2, this.mappingS1, this.mappingS2, listener);
        System.out.println("OBJECTS-------------------");
        CatIterator commonObject1 = new CatIterator(new CatCommon(dictionary1.getObjects().getSortedEntries(), dictionary2.getShared().getSortedEntries()), new CatCommon(dictionary1.getObjects().getSortedEntries(), dictionary2.getSubjects().getSortedEntries()));
        int numCommonObject1Hdt2 = 0;
        while (commonObject1.hasNext()) {
            commonObject1.next();
            ++numCommonObject1Hdt2;
        }
        CatIterator commonObject2 = new CatIterator(new CatCommon(dictionary2.getObjects().getSortedEntries(), dictionary1.getShared().getSortedEntries()), new CatCommon(dictionary2.getObjects().getSortedEntries(), dictionary1.getSubjects().getSortedEntries()));
        int numCommonObject2Hdt1 = 0;
        while (commonObject2.hasNext()) {
            commonObject2.next();
            ++numCommonObject2Hdt1;
        }
        int numCommonObjects = 0;
        CatCommon commonO1O2 = new CatCommon(dictionary1.getObjects().getSortedEntries(), dictionary2.getObjects().getSortedEntries());
        while (commonO1O2.hasNext()) {
            commonO1O2.next();
            ++numCommonObjects;
        }
        commonObject1 = new CatIterator(new CatCommon(dictionary1.getObjects().getSortedEntries(), dictionary2.getShared().getSortedEntries()), new CatCommon(dictionary1.getObjects().getSortedEntries(), dictionary2.getSubjects().getSortedEntries()));
        commonObject2 = new CatIterator(new CatCommon(dictionary2.getObjects().getSortedEntries(), dictionary1.getShared().getSortedEntries()), new CatCommon(dictionary2.getObjects().getSortedEntries(), dictionary1.getSubjects().getSortedEntries()));
        this.mappingO1 = new CatMapping(this.location, "O1", (int)dictionary1.getObjects().getNumberOfElements());
        this.mappingO2 = new CatMapping(this.location, "O2", (int)dictionary2.getObjects().getNumberOfElements());
        long numObject = dictionary1.getObjects().getNumberOfElements() + dictionary2.getObjects().getNumberOfElements() - (long)numCommonObjects - (long)numCommonObject1Hdt2 - (long)numCommonObject2Hdt1;
        this.catSection(numObject, 3, dictionary1.getObjects(), dictionary2.getObjects(), commonObject1, commonObject2, this.mappingO1, this.mappingO2, listener);
        System.out.println("SHARED-------------------");
        CatCommon i2 = new CatCommon(dictionary1.getSubjects().getSortedEntries(), dictionary2.getObjects().getSortedEntries());
        int numCommonS1O2 = 0;
        while (i2.hasNext()) {
            i2.next();
            ++numCommonS1O2;
        }
        Iterator<? extends CharSequence> it = dictionary2.getSubjects().getSortedEntries();
        i2 = new CatCommon(dictionary1.getObjects().getSortedEntries(), dictionary2.getSubjects().getSortedEntries());
        int numCommonO1S2 = 0;
        while (i2.hasNext()) {
            i2.next();
            ++numCommonO1S2;
        }
        i2 = new CatCommon(dictionary1.getShared().getSortedEntries(), dictionary2.getShared().getSortedEntries());
        int numCommonSh1Sh2 = 0;
        while (i2.hasNext()) {
            i2.next();
            ++numCommonSh1Sh2;
        }
        this.numShared = dictionary1.getShared().getNumberOfElements() + dictionary2.getShared().getNumberOfElements() - (long)numCommonSh1Sh2 + (long)numCommonS1O2 + (long)numCommonO1S2;
        this.catShared(this.numShared, dictionary1, dictionary2, listener);
        ControlInformation ci = new ControlInformation();
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat("<http://purl.org/HDT/hdt#dictionaryFour>");
        ci.setInt("elements", numSubjects + numPredicates + numObject + this.numShared);
        try {
            ci.save(new FileOutputStream(this.location + "dictionary"));
            FileOutputStream outFinal = new FileOutputStream(this.location + "dictionary", true);
            byte[] buf = new byte[100000];
            for (int i = 1; i <= 4; ++i) {
                int j = i;
                if (i == 4) {
                    j = 3;
                } else if (j == 3) {
                    j = 4;
                }
                try {
                    FileInputStream in = new FileInputStream(this.location + "section" + j);
                    int b = 0;
                    while ((b = ((InputStream)in).read(buf)) >= 0) {
                        outFinal.write(buf, 0, b);
                        outFinal.flush();
                    }
                    ((InputStream)in).close();
                    Files.delete(Paths.get(this.location + "section" + j, new String[0]));
                    continue;
                }
                catch (FileNotFoundException e2) {
                    e2.printStackTrace();
                }
            }
            outFinal.close();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        this.mappingS = new CatMappingBack(this.location, numSubjects + this.numShared);
        int i = 0;
        while ((long)i < this.mappingSh1.getSize()) {
            this.mappingS.set(this.mappingSh1.getMapping(i), i + 1, 1);
            ++i;
        }
        i = 0;
        while ((long)i < this.mappingSh2.getSize()) {
            this.mappingS.set(this.mappingSh2.getMapping(i), i + 1, 2);
            ++i;
        }
        i = 0;
        while ((long)i < this.mappingS1.getSize()) {
            if (this.mappingS1.getType(i) == 1L) {
                this.mappingS.set(this.mappingS1.getMapping(i), i + 1 + (int)dictionary1.getNshared(), 1);
            } else {
                this.mappingS.set(this.mappingS1.getMapping(i) + (long)((int)this.numShared), i + 1 + (int)dictionary1.getNshared(), 1);
            }
            ++i;
        }
        i = 0;
        while ((long)i < this.mappingS2.getSize()) {
            if (this.mappingS2.getType(i) == 1L) {
                this.mappingS.set(this.mappingS2.getMapping(i), i + 1 + (int)dictionary2.getNshared(), 2);
            } else {
                this.mappingS.set(this.mappingS2.getMapping(i) + (long)((int)this.numShared), i + 1 + (int)dictionary2.getNshared(), 2);
            }
            ++i;
        }
    }

    public void catSection(long numentries, int type, DictionarySection dictionarySectionHdt1, DictionarySection dictionarySectionHdt2, Iterator<Integer> it1common, Iterator<Integer> it2common, CatMapping mappingHdt1, CatMapping mappingHdt2, ProgressListener listener) {
        CRCOutputStream out_buffer = null;
        try {
            out_buffer = new CRCOutputStream(new FileOutputStream(this.location + "section_buffer_" + type), new CRC32());
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        try {
            String name = "";
            switch (type) {
                case 2: {
                    name = "subject";
                }
                case 3: {
                    name = "object";
                }
                case 4: {
                    name = "predicate";
                }
            }
            int count1 = 0;
            int count2 = 0;
            int skipSection1 = -1;
            int skipSection2 = -1;
            long storedBuffersSize = 0L;
            long numBlocks = 0L;
            long numberElements = 0L;
            SequenceLog64BigDisk blocks = new SequenceLog64BigDisk(this.location + "SequenceLog64BigDisk" + type, 64, numentries / 16L);
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(16384);
            if (numentries > 0L) {
                String previousStr = null;
                Iterator<? extends CharSequence> it1 = dictionarySectionHdt1.getSortedEntries();
                Iterator<? extends CharSequence> it2 = dictionarySectionHdt2.getSortedEntries();
                ArrayList<IteratorPlusString> list = new ArrayList<IteratorPlusString>();
                CharSequenceComparator comparator = new CharSequenceComparator();
                if (it1.hasNext()) {
                    list.add(new IteratorPlusString(1, it1.next()));
                }
                if (it2.hasNext()) {
                    list.add(new IteratorPlusString(2, it2.next()));
                }
                if (it1common.hasNext()) {
                    skipSection1 = it1common.next();
                }
                if (it2common.hasNext()) {
                    skipSection2 = it2common.next();
                }
                while (list.size() != 0) {
                    ListenerUtil.notifyCond(listener, "Analyze section " + name + " ", numberElements, numberElements, numentries);
                    Collections.sort(list, new IteratorPlusStringComparator());
                    boolean skip = false;
                    if (((IteratorPlusString)list.get((int)0)).iterator == 1) {
                        if (count1 == skipSection1) {
                            skip = true;
                            if (it1.hasNext()) {
                                list.set(0, new IteratorPlusString(1, it1.next()));
                                ++count1;
                            } else {
                                list.remove(0);
                            }
                            if (it1common.hasNext()) {
                                skipSection1 = it1common.next();
                            }
                        }
                    } else if (count2 == skipSection2) {
                        skip = true;
                        if (it2.hasNext()) {
                            list.set(0, new IteratorPlusString(2, it2.next()));
                            ++count2;
                        } else {
                            list.remove(0);
                        }
                        if (it2common.hasNext()) {
                            skipSection2 = it2common.next();
                        }
                    }
                    if (skip) continue;
                    String str2 = ((IteratorPlusString)list.get((int)0)).value.toString();
                    if (numberElements % (long)this.DEFAULT_BLOCK_SIZE == 0L) {
                        blocks.append(storedBuffersSize + (long)byteOut.size());
                        if ((++numBlocks - 1L) % (long)this.BLOCK_PER_BUFFER == 0L && (numBlocks - 1L) / (long)this.BLOCK_PER_BUFFER != 0L) {
                            storedBuffersSize += (long)byteOut.size();
                            byteOut.flush();
                            IOUtil.writeBuffer(out_buffer, byteOut.toByteArray(), 0, byteOut.toByteArray().length, null);
                            byteOut.close();
                            byteOut = new ByteArrayOutputStream(16384);
                        }
                        ByteStringUtil.append(byteOut, str2, 0);
                    } else {
                        int delta = ByteStringUtil.longestCommonPrefix(previousStr, str2);
                        VByte.encode(byteOut, delta);
                        ByteStringUtil.append(byteOut, str2, delta);
                    }
                    byteOut.write(0);
                    previousStr = str2;
                    if (list.size() >= 2 && ((IteratorPlusString)list.get((int)0)).value.toString().equals(((IteratorPlusString)list.get((int)1)).value.toString())) {
                        boolean removed = false;
                        mappingHdt1.set(count1, numberElements + 1L, type);
                        ++count1;
                        mappingHdt2.set(count2, numberElements + 1L, type);
                        ++count2;
                        if (it1.hasNext()) {
                            list.set(0, new IteratorPlusString(1, it1.next()));
                        } else {
                            list.remove(0);
                            removed = true;
                        }
                        if (it2.hasNext()) {
                            if (removed) {
                                list.set(0, new IteratorPlusString(2, it2.next()));
                            } else {
                                list.set(1, new IteratorPlusString(2, it2.next()));
                            }
                        } else if (removed) {
                            list.remove(0);
                        } else {
                            list.remove(1);
                        }
                    } else if (((IteratorPlusString)list.get((int)0)).iterator == 1) {
                        mappingHdt1.set(count1, numberElements + 1L, type);
                        ++count1;
                        if (it1.hasNext()) {
                            list.set(0, new IteratorPlusString(1, it1.next()));
                        } else {
                            list.remove(0);
                        }
                    } else if (((IteratorPlusString)list.get((int)0)).iterator == 2) {
                        mappingHdt2.set(count2, numberElements + 1L, type);
                        ++count2;
                        if (it2.hasNext()) {
                            list.set(0, new IteratorPlusString(2, it2.next()));
                        } else {
                            list.remove(0);
                        }
                    }
                    ++numberElements;
                }
            }
            blocks.append(storedBuffersSize + (long)byteOut.size());
            blocks.aggressiveTrimToSize();
            byteOut.flush();
            IOUtil.writeBuffer(out_buffer, byteOut.toByteArray(), 0, byteOut.toByteArray().length, null);
            out_buffer.writeCRC();
            out_buffer.close();
            CRCOutputStream out = new CRCOutputStream(new FileOutputStream(this.location + "section" + type), new CRC8());
            out.write(2);
            VByte.encode(out, numberElements);
            VByte.encode(out, storedBuffersSize + (long)byteOut.size());
            VByte.encode(out, this.DEFAULT_BLOCK_SIZE);
            out.writeCRC();
            blocks.save(out, null);
            blocks.close();
            byte[] buf = new byte[100000];
            FileInputStream in = new FileInputStream(this.location + "section_buffer_" + type);
            int b = 0;
            while ((b = ((InputStream)in).read(buf)) >= 0) {
                out.write(buf, 0, b);
                out.flush();
            }
            out.close();
            Files.delete(Paths.get(this.location + "section_buffer_" + type, new String[0]));
            Files.delete(Paths.get(this.location + "SequenceLog64BigDisk" + type, new String[0]));
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public void catShared(long numentries, Dictionary dictionaryHdt1, Dictionary dictionaryHdt2, ProgressListener listener) {
        CRCOutputStream out_buffer = null;
        try {
            out_buffer = new CRCOutputStream(new FileOutputStream(this.location + "section_buffer_" + 1), new CRC32());
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        this.mappingSh1 = new CatMapping(this.location, "SH1", (int)dictionaryHdt1.getShared().getNumberOfElements());
        this.mappingSh2 = new CatMapping(this.location, "SH2", (int)dictionaryHdt2.getShared().getNumberOfElements());
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(16384);
            SequenceLog64BigDisk blocks = new SequenceLog64BigDisk(this.location + "SequenceLog64BigDisk" + 1, 64, numentries / 16L);
            String previousStr = null;
            int count1 = 0;
            int count2 = 0;
            Pair idS1O2 = null;
            Pair idO1S2 = null;
            long storedBuffersSize = 0L;
            long numberElements = 0L;
            long numBlocks = 0L;
            if (numentries > 0L) {
                Iterator<? extends CharSequence> it1 = dictionaryHdt1.getShared().getSortedEntries();
                Iterator<? extends CharSequence> it2 = dictionaryHdt2.getShared().getSortedEntries();
                CatCommon iteratorCommonSubjects1Objects2 = new CatCommon(dictionaryHdt1.getSubjects().getSortedEntries(), dictionaryHdt2.getObjects().getSortedEntries());
                CatCommon iteratorCommonObjects1Subjects2 = new CatCommon(dictionaryHdt1.getObjects().getSortedEntries(), dictionaryHdt2.getSubjects().getSortedEntries());
                CatCommon iteratorCommonShared1Subjects2 = new CatCommon(dictionaryHdt1.getShared().getSortedEntries(), dictionaryHdt2.getSubjects().getSortedEntries());
                CatCommon iteratorCommonShared1Objects2 = new CatCommon(dictionaryHdt1.getShared().getSortedEntries(), dictionaryHdt2.getObjects().getSortedEntries());
                CatCommon iteratorCommonShared2Subjects1 = new CatCommon(dictionaryHdt2.getShared().getSortedEntries(), dictionaryHdt1.getSubjects().getSortedEntries());
                CatCommon iteratorCommonShared2Objects1 = new CatCommon(dictionaryHdt2.getShared().getSortedEntries(), dictionaryHdt1.getObjects().getSortedEntries());
                Pair commonShared1Subjects2 = new Pair(-1, -1);
                Pair commonShared1Objects2 = new Pair(-1, -1);
                Pair commonShared2Subjects1 = new Pair(-1, -1);
                Pair commonShared2Objects1 = new Pair(-1, -1);
                if (iteratorCommonShared1Subjects2.hasNext()) {
                    commonShared1Subjects2 = (Pair)iteratorCommonShared1Subjects2.next();
                }
                if (iteratorCommonShared1Objects2.hasNext()) {
                    commonShared1Objects2 = (Pair)iteratorCommonShared1Objects2.next();
                }
                if (iteratorCommonShared2Subjects1.hasNext()) {
                    commonShared2Subjects1 = (Pair)iteratorCommonShared2Subjects1.next();
                }
                if (iteratorCommonShared2Objects1.hasNext()) {
                    commonShared2Objects1 = (Pair)iteratorCommonShared2Objects1.next();
                }
                ArrayList<IteratorPlusString> list = new ArrayList<IteratorPlusString>();
                CharSequenceComparator comparator = new CharSequenceComparator();
                if (it1.hasNext()) {
                    list.add(new IteratorPlusString(1, it1.next()));
                }
                if (it2.hasNext()) {
                    list.add(new IteratorPlusString(2, it2.next()));
                }
                if (iteratorCommonSubjects1Objects2.hasNext()) {
                    idS1O2 = (Pair)iteratorCommonSubjects1Objects2.next();
                    list.add(new IteratorPlusString(3, dictionaryHdt1.getSubjects().extract((Integer)idS1O2.getKey() + 1)));
                }
                if (iteratorCommonObjects1Subjects2.hasNext()) {
                    idO1S2 = (Pair)iteratorCommonObjects1Subjects2.next();
                    list.add(new IteratorPlusString(4, dictionaryHdt1.getObjects().extract((Integer)idO1S2.getKey() + 1)));
                }
                while (list.size() != 0) {
                    ListenerUtil.notifyCond(listener, "Analyze section shared ", numberElements, numberElements, numentries);
                    Collections.sort(list, new IteratorPlusStringComparator());
                    String str2 = ((IteratorPlusString)list.get((int)0)).value.toString();
                    if (numberElements % (long)this.DEFAULT_BLOCK_SIZE == 0L) {
                        blocks.append(storedBuffersSize + (long)byteOut.size());
                        if ((++numBlocks - 1L) % (long)this.BLOCK_PER_BUFFER == 0L && (numBlocks - 1L) / (long)this.BLOCK_PER_BUFFER != 0L) {
                            storedBuffersSize += (long)byteOut.size();
                            byteOut.flush();
                            IOUtil.writeBuffer(out_buffer, byteOut.toByteArray(), 0, byteOut.toByteArray().length, null);
                            byteOut.close();
                            byteOut = new ByteArrayOutputStream(16384);
                        }
                        ByteStringUtil.append(byteOut, str2, 0);
                    } else {
                        int delta = ByteStringUtil.longestCommonPrefix(previousStr, str2);
                        VByte.encode(byteOut, delta);
                        ByteStringUtil.append(byteOut, str2, delta);
                    }
                    byteOut.write(0);
                    previousStr = str2;
                    if (list.size() >= 2 && ((IteratorPlusString)list.get((int)0)).value.toString().equals(((IteratorPlusString)list.get((int)1)).value.toString())) {
                        this.mappingSh1.set(count1, numberElements + 1L, 1);
                        this.mappingSh2.set(count2, numberElements + 1L, 1);
                        if (count1 == (Integer)commonShared1Subjects2.getKey()) {
                            this.mappingS2.set(((Integer)commonShared1Subjects2.getValue()).intValue(), numberElements + 1L, 1);
                        }
                        if (count1 == (Integer)commonShared1Objects2.getKey()) {
                            this.mappingO2.set(((Integer)commonShared1Objects2.getValue()).intValue(), numberElements + 1L, 1);
                        }
                        if (count2 == (Integer)commonShared2Subjects1.getKey()) {
                            this.mappingS1.set(((Integer)commonShared2Subjects1.getValue()).intValue(), numberElements + 1L, 1);
                        }
                        if (count2 == (Integer)commonShared2Objects1.getKey()) {
                            this.mappingO1.set(((Integer)commonShared2Objects1.getValue()).intValue(), numberElements + 1L, 1);
                        }
                        boolean removed = false;
                        if (it1.hasNext()) {
                            list.set(0, new IteratorPlusString(1, it1.next()));
                            if (++count1 > (Integer)commonShared1Subjects2.getKey() && iteratorCommonShared1Subjects2.hasNext()) {
                                commonShared1Subjects2 = (Pair)iteratorCommonShared1Subjects2.next();
                            }
                            if (count1 > (Integer)commonShared1Objects2.getKey() && iteratorCommonShared1Objects2.hasNext()) {
                                commonShared1Objects2 = (Pair)iteratorCommonShared1Objects2.next();
                            }
                        } else {
                            removed = true;
                        }
                        if (it2.hasNext()) {
                            list.set(1, new IteratorPlusString(2, it2.next()));
                            if (++count2 > (Integer)commonShared2Subjects1.getKey() && iteratorCommonShared2Subjects1.hasNext()) {
                                commonShared2Subjects1 = (Pair)iteratorCommonShared2Subjects1.next();
                            }
                            if (count2 > (Integer)commonShared2Objects1.getKey() && iteratorCommonShared2Objects1.hasNext()) {
                                commonShared2Objects1 = (Pair)iteratorCommonShared2Objects1.next();
                            }
                        } else {
                            list.remove(1);
                        }
                        if (removed) {
                            list.remove(0);
                        }
                    } else if (((IteratorPlusString)list.get((int)0)).iterator == 1) {
                        this.mappingSh1.set(count1, numberElements + 1L, 1);
                        if (count1 == (Integer)commonShared1Subjects2.getKey()) {
                            this.mappingS2.set(((Integer)commonShared1Subjects2.getValue()).intValue(), numberElements + 1L, 1);
                        }
                        if (count1 == (Integer)commonShared1Objects2.getKey()) {
                            this.mappingO2.set(((Integer)commonShared1Objects2.getValue()).intValue(), numberElements + 1L, 1);
                        }
                        if (it1.hasNext()) {
                            list.set(0, new IteratorPlusString(1, it1.next()));
                            if (++count1 > (Integer)commonShared1Subjects2.getKey() && iteratorCommonShared1Subjects2.hasNext()) {
                                commonShared1Subjects2 = (Pair)iteratorCommonShared1Subjects2.next();
                            }
                            if (count1 > (Integer)commonShared1Objects2.getKey() && iteratorCommonShared1Objects2.hasNext()) {
                                commonShared1Objects2 = (Pair)iteratorCommonShared1Objects2.next();
                            }
                        } else {
                            list.remove(0);
                        }
                    } else if (((IteratorPlusString)list.get((int)0)).iterator == 2) {
                        this.mappingSh2.set(count2, numberElements + 1L, 1);
                        if (count2 == (Integer)commonShared2Subjects1.getKey()) {
                            this.mappingS1.set(((Integer)commonShared2Subjects1.getValue()).intValue(), numberElements + 1L, 1);
                        }
                        if (count2 == (Integer)commonShared2Objects1.getKey()) {
                            this.mappingO1.set(((Integer)commonShared2Objects1.getValue()).intValue(), numberElements + 1L, 1);
                        }
                        if (it2.hasNext()) {
                            list.set(0, new IteratorPlusString(2, it2.next()));
                            if (++count2 > (Integer)commonShared2Subjects1.getKey() && iteratorCommonShared2Subjects1.hasNext()) {
                                commonShared2Subjects1 = (Pair)iteratorCommonShared2Subjects1.next();
                            }
                            if (count2 > (Integer)commonShared2Objects1.getKey() && iteratorCommonShared2Objects1.hasNext()) {
                                commonShared2Objects1 = (Pair)iteratorCommonShared2Objects1.next();
                            }
                        } else {
                            list.remove(0);
                        }
                    } else if (((IteratorPlusString)list.get((int)0)).iterator == 3) {
                        this.mappingS1.set(((Integer)idS1O2.getKey()).intValue(), numberElements + 1L, 1);
                        this.mappingO2.set(((Integer)idS1O2.getValue()).intValue(), numberElements + 1L, 1);
                        if (iteratorCommonSubjects1Objects2.hasNext()) {
                            idS1O2 = (Pair)iteratorCommonSubjects1Objects2.next();
                            list.set(0, new IteratorPlusString(3, dictionaryHdt1.getSubjects().extract((Integer)idS1O2.getKey() + 1)));
                        } else {
                            list.remove(0);
                        }
                    } else {
                        this.mappingO1.set(((Integer)idO1S2.getKey()).intValue(), numberElements + 1L, 1);
                        this.mappingS2.set(((Integer)idO1S2.getValue()).intValue(), numberElements + 1L, 1);
                        if (iteratorCommonObjects1Subjects2.hasNext()) {
                            idO1S2 = (Pair)iteratorCommonObjects1Subjects2.next();
                            list.set(0, new IteratorPlusString(4, dictionaryHdt2.getSubjects().extract((Integer)idO1S2.getValue() + 1)));
                        } else {
                            list.remove(0);
                        }
                    }
                    ++numberElements;
                }
                blocks.append(storedBuffersSize + (long)byteOut.size());
                blocks.aggressiveTrimToSize();
                byteOut.flush();
                IOUtil.writeBuffer(out_buffer, byteOut.toByteArray(), 0, byteOut.toByteArray().length, null);
            }
            out_buffer.writeCRC();
            out_buffer.close();
            CRCOutputStream out = new CRCOutputStream(new FileOutputStream(this.location + "section" + 1), new CRC8());
            out.write(2);
            VByte.encode(out, numberElements);
            VByte.encode(out, storedBuffersSize + (long)byteOut.size());
            VByte.encode(out, this.DEFAULT_BLOCK_SIZE);
            out.writeCRC();
            blocks.save(out, null);
            blocks.close();
            byte[] buf = new byte[100000];
            FileInputStream in = new FileInputStream(this.location + "section_buffer_" + 1);
            int b = 0;
            while ((b = ((InputStream)in).read(buf)) >= 0) {
                out.write(buf, 0, b);
                out.flush();
            }
            out.close();
            Files.delete(Paths.get(this.location + "section_buffer_" + 1, new String[0]));
            Files.delete(Paths.get(this.location + "SequenceLog64BigDisk" + 1, new String[0]));
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public CatMapping getMappingSh1() {
        return this.mappingSh1;
    }

    public CatMapping getMappingSh2() {
        return this.mappingSh2;
    }

    public CatMapping getMappingS1() {
        return this.mappingS1;
    }

    public CatMapping getMappingS2() {
        return this.mappingS2;
    }

    public CatMapping getMappingO1() {
        return this.mappingO1;
    }

    public CatMapping getMappingO2() {
        return this.mappingO2;
    }

    public CatMapping getMappingP1() {
        return this.mappingP1;
    }

    public CatMapping getMappingP2() {
        return this.mappingP2;
    }

    public CatMappingBack getMappingS() {
        return this.mappingS;
    }

    public long getNumEntriesShared() {
        return this.numShared;
    }
}

