/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator;

import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TripleString;

public class DictionaryTranslateIterator
implements IteratorTripleString {
    final IteratorTripleID iterator;
    final Dictionary dictionary;
    CharSequence s;
    CharSequence p;
    CharSequence o;
    long lastSid;
    long lastPid;
    long lastOid;
    CharSequence lastSstr;
    CharSequence lastPstr;
    CharSequence lastOstr;

    public DictionaryTranslateIterator(IteratorTripleID iteratorTripleID, Dictionary dictionary) {
        this.iterator = iteratorTripleID;
        this.dictionary = dictionary;
        this.o = "";
        this.p = "";
        this.s = "";
    }

    public DictionaryTranslateIterator(IteratorTripleID iteratorTripleID, Dictionary dictionary, CharSequence s, CharSequence p, CharSequence o) {
        this.iterator = iteratorTripleID;
        this.dictionary = dictionary;
        this.s = s == null ? "" : s;
        this.p = p == null ? "" : p;
        this.o = o == null ? "" : o;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public TripleString next() {
        TripleID triple = (TripleID)this.iterator.next();
        if (this.s.length() != 0) {
            this.lastSstr = this.s;
        } else if (triple.getSubject() != this.lastSid) {
            this.lastSid = triple.getSubject();
            this.lastSstr = this.dictionary.idToString(this.lastSid, TripleComponentRole.SUBJECT);
        }
        if (this.p.length() != 0) {
            this.lastPstr = this.p;
        } else if (triple.getPredicate() != this.lastPid) {
            this.lastPstr = this.dictionary.idToString(triple.getPredicate(), TripleComponentRole.PREDICATE);
            this.lastPid = triple.getPredicate();
        }
        if (this.o.length() != 0) {
            this.lastOstr = this.o;
        } else if (triple.getObject() != this.lastOid) {
            this.lastOstr = this.dictionary.idToString(triple.getObject(), TripleComponentRole.OBJECT);
            this.lastOid = triple.getObject();
        }
        return new TripleString(this.lastSstr, this.lastPstr, this.lastOstr);
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void goToStart() {
        this.iterator.goToStart();
    }

    @Override
    public long estimatedNumResults() {
        return this.iterator.estimatedNumResults();
    }

    @Override
    public ResultEstimationType numResultEstimation() {
        return this.iterator.numResultEstimation();
    }
}

