/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.rdfhdt.hdt.dictionary.impl.DictionaryPFCOptimizedExtractor;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionary;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TripleString;

public class DictionaryTranslateIteratorBuffer
implements IteratorTripleString {
    private static int DEFAULT_BLOCK_SIZE = 10000;
    final int blockSize;
    IteratorTripleID iterator;
    DictionaryPFCOptimizedExtractor dictionary;
    CharSequence s;
    CharSequence p;
    CharSequence o;
    List<TripleID> triples;
    Iterator<TripleID> child = Collections.emptyIterator();
    Map<Long, CharSequence> mapSubject;
    Map<Long, CharSequence> mapPredicate;
    Map<Long, CharSequence> mapObject;
    long lastSid;
    long lastPid;
    long lastOid;
    CharSequence lastSstr;
    CharSequence lastPstr;
    CharSequence lastOstr;

    public DictionaryTranslateIteratorBuffer(IteratorTripleID iteratorTripleID, FourSectionDictionary dictionary, CharSequence s, CharSequence p, CharSequence o) {
        this(iteratorTripleID, dictionary, s, p, o, DEFAULT_BLOCK_SIZE);
    }

    public DictionaryTranslateIteratorBuffer(IteratorTripleID iteratorTripleID, FourSectionDictionary dictionary, CharSequence s, CharSequence p, CharSequence o, int blockSize) {
        this.blockSize = blockSize;
        this.iterator = iteratorTripleID;
        this.dictionary = new DictionaryPFCOptimizedExtractor(dictionary);
        this.s = s == null ? "" : s;
        this.p = p == null ? "" : p;
        this.o = o == null ? "" : o;
    }

    private void reset() {
        this.triples = new ArrayList<TripleID>(this.blockSize);
        if (this.s.length() == 0) {
            this.mapSubject = new HashMap<Long, CharSequence>(this.blockSize);
        }
        if (this.p.length() == 0) {
            this.mapPredicate = new HashMap<Long, CharSequence>();
        }
        if (this.o.length() == 0) {
            this.mapObject = new HashMap<Long, CharSequence>(this.blockSize);
        }
    }

    private void fill(long[] arr, int count, Map<Long, CharSequence> map, TripleComponentRole role) {
        Arrays.sort(arr, 0, count);
        long last = -1L;
        for (int i = 0; i < count; ++i) {
            long val = arr[i];
            if (val == last) continue;
            CharSequence str2 = this.dictionary.idToString(val, role);
            map.put(val, str2);
            last = val;
        }
    }

    private void fetchBlock() {
        this.reset();
        long[] arrSubjects = new long[this.blockSize];
        long[] arrPredicates = new long[this.blockSize];
        long[] arrObjects = new long[this.blockSize];
        int count = 0;
        for (int i = 0; i < this.blockSize && this.iterator.hasNext(); ++i) {
            TripleID t = new TripleID((TripleID)this.iterator.next());
            this.triples.add(t);
            if (this.s.length() == 0) {
                arrSubjects[count] = t.getSubject();
            }
            if (this.p.length() == 0) {
                arrPredicates[count] = t.getPredicate();
            }
            if (this.o.length() == 0) {
                arrObjects[count] = t.getObject();
            }
            ++count;
        }
        if (this.s.length() == 0) {
            this.fill(arrSubjects, count, this.mapSubject, TripleComponentRole.SUBJECT);
        }
        if (this.p.length() == 0) {
            this.fill(arrPredicates, count, this.mapPredicate, TripleComponentRole.PREDICATE);
        }
        if (this.o.length() == 0) {
            this.fill(arrObjects, count, this.mapObject, TripleComponentRole.OBJECT);
        }
        this.child = this.triples.iterator();
    }

    @Override
    public boolean hasNext() {
        boolean more;
        boolean bl = more = this.child.hasNext() || this.iterator.hasNext();
        if (!more) {
            this.mapObject = null;
            this.mapPredicate = null;
            this.mapSubject = null;
            this.triples = null;
        }
        return more;
    }

    @Override
    public TripleString next() {
        if (!this.child.hasNext()) {
            this.fetchBlock();
        }
        TripleID triple = this.child.next();
        if (this.s.length() != 0) {
            this.lastSstr = this.s;
        } else if (triple.getSubject() != this.lastSid) {
            this.lastSid = triple.getSubject();
            this.lastSstr = this.mapSubject.get(this.lastSid);
        }
        if (this.p.length() != 0) {
            this.lastPstr = this.p;
        } else if (triple.getPredicate() != this.lastPid) {
            this.lastPid = triple.getPredicate();
            this.lastPstr = this.mapPredicate.get(this.lastPid);
        }
        if (this.o.length() != 0) {
            this.lastOstr = this.o;
        } else if (triple.getObject() != this.lastOid) {
            this.lastOid = triple.getObject();
            this.lastOstr = this.mapObject.get(this.lastOid);
        }
        return new TripleString(this.lastSstr, this.lastPstr, this.lastOstr);
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void goToStart() {
        this.iterator.goToStart();
        this.reset();
    }

    @Override
    public long estimatedNumResults() {
        return this.iterator.estimatedNumResults();
    }

    @Override
    public ResultEstimationType numResultEstimation() {
        return this.iterator.numResultEstimation();
    }

    public static void setBlockSize(int size) {
        DEFAULT_BLOCK_SIZE = size;
    }

    public static int getBlockSize() {
        return DEFAULT_BLOCK_SIZE;
    }
}

