/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.bindings;

import org.apache.jena.graph.Node;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdtjena.NodeDictionary;

public class HDTId {
    private final long id;
    private final TripleComponentRole role;
    private final NodeDictionary dict;
    private Node node;

    public HDTId(long id, TripleComponentRole role, NodeDictionary dict) {
        this.id = id;
        this.role = role;
        this.dict = dict;
    }

    public HDTId(Node node) {
        this(-1L, null, null);
        this.node = node;
    }

    public NodeDictionary getDictionary() {
        return this.dict;
    }

    public long getValue() {
        return this.id;
    }

    public TripleComponentRole getRole() {
        return this.role;
    }

    public String toString() {
        return "(" + this.id + "/" + (Object)((Object)this.role) + ")";
    }

    public Node getNode() {
        if (this.role == null) {
            return null;
        }
        if (this.node == null) {
            this.node = this.dict.getNode(this.id, this.role);
        }
        return this.node;
    }

    public boolean exists() {
        return this.id != -1L;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HDTId)) {
            return false;
        }
        HDTId hdtId = (HDTId)obj;
        return this.exists() && hdtId.exists() && this.id == NodeDictionary.translate(this.dict, hdtId, this.role);
    }
}

