/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.util;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.IteratorWrapper;
import org.apache.jena.query.QueryCancelledException;
import org.rdfhdt.hdtjena.util.Abortable;

public class IterAbortable<T>
extends IteratorWrapper<T>
implements Abortable {
    volatile boolean abortFlag;

    public static <T> Iterator<T> makeAbortable(Iterator<T> iter, List<Abortable> killList) {
        if (killList == null) {
            return iter;
        }
        IterAbortable<T> k = new IterAbortable<T>(iter);
        killList.add(k);
        return k;
    }

    public IterAbortable(Iterator<T> iterator) {
        super(iterator);
    }

    @Override
    public void abort() {
        this.abortFlag = true;
    }

    @Override
    public boolean hasNext() {
        if (this.abortFlag) {
            throw new QueryCancelledException();
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.abortFlag) {
            throw new QueryCancelledException();
        }
        return (T)this.iterator.next();
    }
}

