/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.resultset.rw.ResultSetWriterJSON;
import org.apache.jena.riot.resultset.rw.ResultSetWriterThrift;
import org.apache.jena.riot.resultset.rw.ResultSetWriterXML;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.CSVOutput;
import org.apache.jena.sparql.resultset.TSVOutput;
import org.apache.jena.sparql.resultset.TextOutput;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;

public class ResultSetWriterRegistry {
    private static Map<Lang, ResultSetWriterFactory> registry = new HashMap<Lang, ResultSetWriterFactory>();
    private static boolean initialized = false;
    private static ResultSetWriter writerCSV = new ResultSetWriter(){

        @Override
        public void write(OutputStream out, ResultSet resultSet, Context context2) {
            CSVOutput fmt = new CSVOutput();
            fmt.format(out, resultSet);
        }

        @Override
        public void write(Writer out, ResultSet resultSet, Context context2) {
            throw new NotImplemented("Writer");
        }

        @Override
        public void write(OutputStream out, boolean result, Context context2) {
            CSVOutput fmt = new CSVOutput();
            fmt.format(out, result);
        }
    };
    private static ResultSetWriter writerTSV = new ResultSetWriter(){

        @Override
        public void write(OutputStream out, ResultSet resultSet, Context context2) {
            TSVOutput fmt = new TSVOutput();
            fmt.format(out, resultSet);
        }

        @Override
        public void write(Writer out, ResultSet resultSet, Context context2) {
            throw new NotImplemented("Writer");
        }

        @Override
        public void write(OutputStream out, boolean result, Context context2) {
            TSVOutput fmt = new TSVOutput();
            fmt.format(out, result);
        }
    };
    private static ResultSetWriter writerNone = new ResultSetWriter(){

        @Override
        public void write(OutputStream out, ResultSet resultSet, Context context2) {
        }

        @Override
        public void write(Writer out, ResultSet resultSet, Context context2) {
        }

        @Override
        public void write(OutputStream out, boolean result, Context context2) {
        }
    };
    private static ResultSetWriter writerText = new ResultSetWriter(){

        @Override
        public void write(OutputStream out, ResultSet resultSet, Context context2) {
            Prologue prologue = ResultSetWriterRegistry.choosePrologue(resultSet, context2);
            TextOutput tFmt = new TextOutput(new SerializationContext(prologue));
            tFmt.format(out, resultSet);
        }

        @Override
        public void write(Writer out, ResultSet resultSet, Context context2) {
            throw new NotImplemented("Writer");
        }

        @Override
        public void write(OutputStream out, boolean result, Context context2) {
            TextOutput tFmt = new TextOutput(new SerializationContext((Prologue)null));
            tFmt.format(out, result);
        }
    };

    public static ResultSetWriterFactory getFactory(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static boolean isRegistered(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.containsKey(lang);
    }

    public static void register(Lang lang, ResultSetWriterFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ResultSetWriterFactoryStd factory = new ResultSetWriterFactoryStd();
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetXML, ResultSetWriterXML.factory);
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetJSON, ResultSetWriterJSON.factory);
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetThrift, ResultSetWriterThrift.factory);
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetCSV, factory);
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetTSV, factory);
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetText, factory);
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetNone, factory);
    }

    private static Prologue choosePrologue(ResultSet resultSet, Context context2) {
        try {
            if (context2 != null && context2.get(ARQConstants.symPrologue) != null) {
                return (Prologue)context2.get(ARQConstants.symPrologue);
            }
            Model m = resultSet.getResourceModel();
            if (m != null) {
                return new Prologue(m);
            }
        }
        catch (Exception ex) {
            Log.warn(ARQ.getExecLogger(), "Failed to establish a 'Prologue' for text output: " + ex.getMessage());
        }
        return null;
    }

    private static class ResultSetWriterFactoryStd
    implements ResultSetWriterFactory {
        private ResultSetWriterFactoryStd() {
        }

        @Override
        public ResultSetWriter create(Lang lang) {
            if ((lang = Objects.requireNonNull(lang, "Language must not be null")).equals(ResultSetLang.SPARQLResultSetCSV)) {
                return writerCSV;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetTSV)) {
                return writerTSV;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetText)) {
                return writerText;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetNone)) {
                return writerNone;
            }
            throw new RiotException("Lang not registered (ResultSet writer)");
        }
    }
}

