/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.base;

import java.util.Objects;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.loader.base.LoaderOps;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.base.ProgressMonitor;
import org.slf4j.Logger;

public class ProgressMonitorOutput
implements ProgressMonitor {
    private final MonitorOutput output;
    private final long tickPoint;
    private final int superTick;
    private final Timer timer;
    private boolean inSection = false;
    private int sectionCounter = 0;
    private Timer sectionTimer = null;
    private long sectionTimeInMillis = -1L;
    private long sectionTickCounter = 0L;
    private String label;
    private long counterBatch = 0L;
    private long counterTotal = 0L;
    private long lastTime = -1L;
    private long timeTotalMillis = -1L;

    private Timer getTimer() {
        return this.timer;
    }

    public static ProgressMonitorOutput create(Logger log2, String label, long tickPoint, int superTick) {
        Objects.requireNonNull(log2);
        return ProgressMonitorOutput.create(LoaderOps.outputToLog(log2), label, tickPoint, superTick);
    }

    public static ProgressMonitorOutput create(MonitorOutput output, String label, long tickPoint, int superTick) {
        Objects.requireNonNull(output);
        return new ProgressMonitorOutput(label, tickPoint, superTick, output);
    }

    public ProgressMonitorOutput(String label, long tickPoint, int superTick, MonitorOutput output) {
        this.output = output;
        this.setLabel(label);
        this.tickPoint = tickPoint;
        this.superTick = superTick;
        this.timer = new Timer();
    }

    @Override
    public void startMessage(String msg) {
        if (msg != null) {
            this.output.print(msg, new Object[0]);
        }
    }

    @Override
    public void finishMessage(String msg) {
        long timePoint = this.getTimer().read();
        if (timePoint != 0L) {
            double time = (double)timePoint / 1000.0;
            long runAvgRate = this.getRunningTotal() * 1000L / timePoint;
            this.print("%s: %,d tuples in %.2fs (Avg: %,d)", msg, this.getTicks(), time, runAvgRate);
        } else {
            this.print("%s: %,d (Avg: ----)", msg, this.getTicks());
        }
    }

    @Override
    public void start() {
        this.getTimer().startTimer();
        this.lastTime = 0L;
    }

    @Override
    public void finish() {
        this.getTimer().endTimer();
        this.timeTotalMillis = this.getTimer().getTimeInterval();
    }

    @Override
    public void tick() {
        ++this.counterBatch;
        ++this.counterTotal;
        if (this.inSection) {
            ++this.sectionTickCounter;
        }
        if (ProgressMonitorOutput.tickPoint(this.getRunningTotal(), this.tickPoint)) {
            long timePoint = this.getTimer().readTimer();
            long thisTime = timePoint - this.lastTime;
            if (thisTime != 0L && timePoint != 0L) {
                long batchAvgRate = this.counterBatch * 1000L / thisTime;
                long runAvgRate = this.getRunningTotal() * 1000L / timePoint;
                this.print("Add: %,d %s (Batch: %,d / Avg: %,d)", this.getRunningTotal(), this.label, batchAvgRate, runAvgRate);
            } else {
                this.print("Add: %,d %s (Batch: ---- / Avg: ----)", this.getRunningTotal(), this.label);
            }
            this.lastTime = timePoint;
            if (ProgressMonitorOutput.tickPoint(this.getRunningTotal(), (long)this.superTick * this.tickPoint)) {
                this.elapsed(timePoint);
            }
            this.counterBatch = 0L;
            this.lastTime = timePoint;
        }
    }

    @Override
    public long getTicks() {
        return this.counterTotal;
    }

    private long getRunningTotal() {
        return this.counterTotal;
    }

    @Override
    public long getTime() {
        return this.timeTotalMillis;
    }

    @Override
    public void startSection() {
        if (this.inSection) {
            throw new TDBException("startSection: Already in section");
        }
        this.inSection = true;
        ++this.sectionCounter;
        this.sectionTimer = new Timer();
        this.sectionTimer.startTimer();
        this.sectionTimeInMillis = 0L;
        this.sectionTickCounter = 0L;
    }

    @Override
    public void finishSection() {
        if (!this.inSection) {
            throw new TDBException("finishSection: Not in section");
        }
        this.print("  End file: %s (triples/quads = %,d)", this.label, this.sectionTickCounter);
        this.inSection = false;
        this.sectionTimeInMillis = this.sectionTimer.endTimer();
    }

    @Override
    public long getSectionTicks() {
        return this.sectionTickCounter;
    }

    @Override
    public long getSectionTime() {
        return this.sectionTimeInMillis;
    }

    protected void elapsed(long timerReading) {
        float elapsedSecs = (float)timerReading / 1000.0f;
        this.print("  Elapsed: %,.2f seconds [%s]", Float.valueOf(elapsedSecs), DateTimeUtils.nowAsString());
    }

    private void print(String fmt, Object ... args) {
        if (this.output != null) {
            this.output.print(fmt, args);
        }
    }

    static boolean tickPoint(long counter, long quantum) {
        return counter % quantum == 0L;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }
}

