/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.database_processing.query_string_creation;

import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.molgenis.vibe.core.database_processing.query_string_creation.QueryString;
import org.molgenis.vibe.core.formats.GeneDiseaseCombinationType;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.formats.ResourceUri;

public final class QueryStringGenerator {
    private static final String PREFIXES_DISGENET = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX dcterms: <http://purl.org/dc/terms/>\nPREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX void: <http://rdfs.org/ns/void#>\nPREFIX sio: <http://semanticscience.org/resource/>\nPREFIX so: <http://www.sequenceontology.org/miso/current_svn/term/SO:>\nPREFIX ncit: <http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#>\nPREFIX up: <http://purl.uniprot.org/core/>\nPREFIX dcat: <http://www.w3.org/ns/dcat#>\nPREFIX dctypes: <http://purl.org/dc/dcmitype/>\nPREFIX wi: <http://purl.org/ontology/wi/core#>\nPREFIX eco: <http://purl.obolibrary.org/obo/eco.owl#>\nPREFIX prov: <http://www.w3.org/ns/prov#>\nPREFIX pav: <http://purl.org/pav/>\nPREFIX obo: <http://purl.obolibrary.org/obo/>\n";
    private static final String PREFIXES_CUSTOM = "PREFIX umls: <http://linkedlifedata.com/resource/umls/id/> # DisGeNET\nPREFIX ncbigene: <http://identifiers.org/ncbigene/> # DisGeNET\nPREFIX pda: <http://rdf.disgenet.org/resource/pda/> # DisGeNET\nPREFIX gda: <http://rdf.disgenet.org/resource/gda/> # DisGeNET\nPREFIX hgnc: <http://identifiers.org/hgnc.symbol/> # DisGeNET\nPREFIX ordo: <http://www.orpha.net/ORDO/> # DisGeNET / Orphanet\nPREFIX hoom: <http://www.semanticweb.org/ontology/HOOM#> # Orphanet\nPREFIX dvoid: <http://rdf.disgenet.org/v7.0.0/void/> # DisGeNET\nPREFIX dvoid5: <http://rdf.disgenet.org/v5.0.0/void/> # DisGeNET\nPREFIX pmid: <http://identifiers.org/pubmed/> # DisGeNET\n";
    private static final String PREFIXES = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX dcterms: <http://purl.org/dc/terms/>\nPREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX void: <http://rdfs.org/ns/void#>\nPREFIX sio: <http://semanticscience.org/resource/>\nPREFIX so: <http://www.sequenceontology.org/miso/current_svn/term/SO:>\nPREFIX ncit: <http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#>\nPREFIX up: <http://purl.uniprot.org/core/>\nPREFIX dcat: <http://www.w3.org/ns/dcat#>\nPREFIX dctypes: <http://purl.org/dc/dcmitype/>\nPREFIX wi: <http://purl.org/ontology/wi/core#>\nPREFIX eco: <http://purl.obolibrary.org/obo/eco.owl#>\nPREFIX prov: <http://www.w3.org/ns/prov#>\nPREFIX pav: <http://purl.org/pav/>\nPREFIX obo: <http://purl.obolibrary.org/obo/>\nPREFIX umls: <http://linkedlifedata.com/resource/umls/id/> # DisGeNET\nPREFIX ncbigene: <http://identifiers.org/ncbigene/> # DisGeNET\nPREFIX pda: <http://rdf.disgenet.org/resource/pda/> # DisGeNET\nPREFIX gda: <http://rdf.disgenet.org/resource/gda/> # DisGeNET\nPREFIX hgnc: <http://identifiers.org/hgnc.symbol/> # DisGeNET\nPREFIX ordo: <http://www.orpha.net/ORDO/> # DisGeNET / Orphanet\nPREFIX hoom: <http://www.semanticweb.org/ontology/HOOM#> # Orphanet\nPREFIX dvoid: <http://rdf.disgenet.org/v7.0.0/void/> # DisGeNET\nPREFIX dvoid5: <http://rdf.disgenet.org/v5.0.0/void/> # DisGeNET\nPREFIX pmid: <http://identifiers.org/pubmed/> # DisGeNET\n";
    private static final String SOURCES = "SELECT ?source ?sourceTitle ?sourceLevel \nWHERE {\n\t?source rdf:type dctypes:Dataset , dcat:Distribution ;\n\twi:evidence ?sourceLevel ;\n\tdcterms:title ?sourceTitle .\n}";
    private static final String[] GENES_FOR_PHENOTYPES = new String[]{"SELECT ?hpo ?disease ?diseaseName ?gene ?geneSymbol ?gdaScoreNumber ?gdaSource ?evidenceYear ?evidence\nWHERE {\n\tVALUES ?hpo ", "\n\t{\n\t\t# Diseases that are UMLS phenotypes.\n\t\t?hpo skos:exactMatch ?disease .\n\t}\n\tUNION\n\t{\n\t\t# Diseases found through phenotype-disease associations.\n\t\t?hpo sio:SIO_000212/sio:SIO_000628 ?disease .\n\t}\n\tUNION\n\t{\n\t\t# Diseases found through Orphanet (HPO - ORDO Ontological Module).\n\t\t?hpo sio:SIO_000001/skos:exactMatch ?disease .\n\t}\n\n\t?disease sio:SIO_000212 ?gda ;\n\tdcterms:title ?diseaseName .\t\n\t?gda rdf:type/rdfs:subClassOf* ", " ;\n\tsio:SIO_000628 ?gene ;\n\tsio:SIO_000216 ?gdaScoreNumber ;\n\tsio:SIO_000253 ?gdaSource .\n\tOPTIONAL {\n\t\t?gda sio:SIO_000772 ?evidence .\n\t\t?evidence dcterms:issued ?evidenceYear .\n\t}\n\n\t?gene sio:SIO_000205 ?geneSymbol .\n}"};

    public static QueryString getSources() {
        return new QueryString("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX dcterms: <http://purl.org/dc/terms/>\nPREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX void: <http://rdfs.org/ns/void#>\nPREFIX sio: <http://semanticscience.org/resource/>\nPREFIX so: <http://www.sequenceontology.org/miso/current_svn/term/SO:>\nPREFIX ncit: <http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#>\nPREFIX up: <http://purl.uniprot.org/core/>\nPREFIX dcat: <http://www.w3.org/ns/dcat#>\nPREFIX dctypes: <http://purl.org/dc/dcmitype/>\nPREFIX wi: <http://purl.org/ontology/wi/core#>\nPREFIX eco: <http://purl.obolibrary.org/obo/eco.owl#>\nPREFIX prov: <http://www.w3.org/ns/prov#>\nPREFIX pav: <http://purl.org/pav/>\nPREFIX obo: <http://purl.obolibrary.org/obo/>\nPREFIX umls: <http://linkedlifedata.com/resource/umls/id/> # DisGeNET\nPREFIX ncbigene: <http://identifiers.org/ncbigene/> # DisGeNET\nPREFIX pda: <http://rdf.disgenet.org/resource/pda/> # DisGeNET\nPREFIX gda: <http://rdf.disgenet.org/resource/gda/> # DisGeNET\nPREFIX hgnc: <http://identifiers.org/hgnc.symbol/> # DisGeNET\nPREFIX ordo: <http://www.orpha.net/ORDO/> # DisGeNET / Orphanet\nPREFIX hoom: <http://www.semanticweb.org/ontology/HOOM#> # Orphanet\nPREFIX dvoid: <http://rdf.disgenet.org/v7.0.0/void/> # DisGeNET\nPREFIX dvoid5: <http://rdf.disgenet.org/v5.0.0/void/> # DisGeNET\nPREFIX pmid: <http://identifiers.org/pubmed/> # DisGeNET\nSELECT ?source ?sourceTitle ?sourceLevel \nWHERE {\n\t?source rdf:type dctypes:Dataset , dcat:Distribution ;\n\twi:evidence ?sourceLevel ;\n\tdcterms:title ?sourceTitle .\n}");
    }

    public static QueryString getGenesForPhenotypes(Set<Phenotype> phenotypes) {
        return new QueryString(PREFIXES + GENES_FOR_PHENOTYPES[0] + QueryStringGenerator.createValuesStringForUris(phenotypes) + GENES_FOR_PHENOTYPES[1] + GeneDiseaseCombinationType.GENE_DISEASE.getFormattedId() + GENES_FOR_PHENOTYPES[2]);
    }

    private QueryStringGenerator() {
    }

    private static String createValuesStringForUris(Set<? extends ResourceUri> resourceUris) {
        if (resourceUris.isEmpty()) {
            throw new IllegalArgumentException("Set should at least contain 1 item.");
        }
        Iterator<? extends ResourceUri> resourceUriIterator = resourceUris.iterator();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("{ <").append(resourceUriIterator.next().getUri());
        while (resourceUriIterator.hasNext()) {
            URI uri = resourceUriIterator.next().getUri();
            if (uri == null) {
                throw new IllegalArgumentException("Not all Objects have a valid URI (an uri was null).");
            }
            strBuilder.append("> <").append(uri);
        }
        return strBuilder.append("> }").toString();
    }
}

