/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64;
import org.rdfhdt.hdt.util.string.ByteStringUtil;

public class PFCDictionarySectionBuilder {
    private byte[] text = new byte[0];
    private int blocksize;
    private int numstrings;
    private SequenceLog64 blocks;
    ByteArrayOutputStream byteOut = new ByteArrayOutputStream(16384);
    CharSequence previousStr = null;

    public PFCDictionarySectionBuilder(int blocksize, long numentries) {
        this.blocksize = blocksize;
        this.blocks = new SequenceLog64(32, numentries / (long)blocksize);
        this.numstrings = 0;
    }

    public void add(CharSequence str2) throws IOException {
        if (this.numstrings % this.blocksize == 0) {
            this.blocks.append(this.byteOut.size());
            ByteStringUtil.append(this.byteOut, str2, 0);
        } else {
            int delta = ByteStringUtil.longestCommonPrefix(this.previousStr, str2);
            VByte.encode(this.byteOut, delta);
            ByteStringUtil.append(this.byteOut, str2, delta);
        }
        this.byteOut.write(0);
        ++this.numstrings;
        this.previousStr = str2;
    }

    public void finished() throws IOException {
        this.blocks.append(this.byteOut.size());
        this.blocks.aggressiveTrimToSize();
        this.byteOut.flush();
        this.text = this.byteOut.toByteArray();
    }

    public byte[] getText() {
        return this.text;
    }

    public int getBlocksize() {
        return this.blocksize;
    }

    public int getNumstrings() {
        return this.numstrings;
    }

    public SequenceLog64 getBlocks() {
        return this.blocks;
    }
}

