/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;

public class JenaNodeFormatter {
    private JenaNodeFormatter() {
    }

    public static String format(RDFNode n) {
        return JenaNodeFormatter.format(n.asNode());
    }

    public static String format(Node node) {
        if (node.isURI()) {
            return node.getURI();
        }
        if (node.isLiteral()) {
            RDFDatatype t = node.getLiteralDatatype();
            if (t == null || XSDDatatype.XSDstring.getURI().equals(t.getURI())) {
                return '\"' + node.getLiteralLexicalForm() + '\"';
            }
            if (RDFLangString.rdfLangString.equals(t)) {
                return '\"' + node.getLiteralLexicalForm() + "\"@" + node.getLiteralLanguage().toLowerCase();
            }
            return '\"' + node.getLiteralLexicalForm() + "\"^^<" + t.getURI() + '>';
        }
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeLabel();
        }
        throw new IllegalArgumentException(String.valueOf(node));
    }
}

