/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParserSimple
implements RDFParserCallback {
    private static final Logger log = LoggerFactory.getLogger(RDFParserSimple.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doParse(String fileName, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        BufferedReader reader;
        try {
            reader = IOUtil.getFileReader(fileName);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new ParserException(e2);
        }
        try {
            this.doParse(reader, baseUri, notation, callback);
        }
        finally {
            IOUtil.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doParse(InputStream input, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        try {
            this.doParse(reader, baseUri, notation, callback);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void doParse(BufferedReader reader, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            String line;
            long numLine = 1L;
            TripleString triple = new TripleString();
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim().replaceAll("\\t", " ")).startsWith("#")) {
                    triple.read(line);
                    if (!triple.hasEmpty()) {
                        callback.processTriple(triple, 0L);
                    } else {
                        System.err.println("Warning: Could not parse triple at line " + numLine + ", ignored and not processed.\n" + line);
                    }
                }
                ++numLine;
            }
            reader.close();
        }
        catch (Exception e2) {
            log.error("Unexpected exception.", e2);
            throw new ParserException(e2);
        }
    }
}

