/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.NonCloseInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParserTar
implements RDFParserCallback {
    private static final Logger log = LoggerFactory.getLogger(RDFParserTar.class);

    @Override
    public void doParse(String fileName, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            InputStream input = IOUtil.getFileInputStream(fileName);
            this.doParse(input, baseUri, notation, callback);
            input.close();
        }
        catch (Exception e2) {
            log.error("Unexpected exception parsing file: {}", (Object)fileName, (Object)e2);
            throw new ParserException();
        }
    }

    @Override
    public void doParse(InputStream input, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", input);
            TarArchiveEntry entry = null;
            NonCloseInputStream nonCloseIn = new NonCloseInputStream(debInputStream);
            while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                if (!entry.isFile() || entry.getName().contains("DS_Store")) continue;
                try {
                    RDFNotation guessnot = RDFNotation.guess(entry.getName());
                    log.info("Parse from tar: {} as {}", (Object)entry.getName(), (Object)guessnot);
                    RDFParserCallback parser = RDFParserFactory.getParserCallback(guessnot);
                    parser.doParse(nonCloseIn, baseUri, guessnot, callback);
                }
                catch (IllegalArgumentException | ParserException e1) {
                    log.error("Unexpected exception.", e1);
                }
            }
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            throw new ParserException();
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new ParserException();
        }
    }
}

