/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.rdf.RDFParserCallback;

public class RDFInfo {
    public static final String size_prop = "rdf.sizeInBytes";
    public static final String triples_prop = "rdf.triples";
    public static final String compression_prop = "rdf.expectedCompression";

    private RDFInfo() {
    }

    public static void fillHDTSpecifications(long sizeInBytes, long numLines, HDTOptions specs) {
        if (sizeInBytes < 0L) {
            System.err.println("WARNING! Setting rdf.sizeInBytes to a negative value!");
        }
        specs.setInt(size_prop, sizeInBytes);
        if (numLines < 0L) {
            System.err.println("WARNING! Setting rdf.triples to a negative value!");
        }
        specs.setInt(triples_prop, numLines);
    }

    public static void setSizeInBytes(long sizeInBytes, HDTOptions specs) {
        specs.setInt(size_prop, sizeInBytes);
    }

    public static void setTriples(long numLines, HDTOptions specs) {
        specs.setInt(triples_prop, numLines);
    }

    public static void setCompression(float compression, HDTOptions specs) {
        specs.set(compression_prop, String.format("%.3f", Float.valueOf(compression)));
    }

    public static Long getSizeInBytes(HDTOptions specs) {
        long x = specs.getInt(size_prop);
        if (x > 0L) {
            return x;
        }
        return null;
    }

    public static long getTriples(HDTOptions specs) {
        return specs.getInt(triples_prop);
    }

    public static boolean triplesSet(HDTOptions specs) {
        return specs.get(triples_prop) != null;
    }

    public static float getCompression(HDTOptions specs) {
        float compression;
        try {
            compression = Float.parseFloat(specs.get(compression_prop));
        }
        catch (NumberFormatException e2) {
            System.err.println("rdf.expectedCompression improperly set, using default 0.15");
            compression = 0.15f;
            RDFInfo.setCompression(compression, specs);
        }
        catch (NullPointerException e3) {
            System.err.println("rdf.expectedCompression missing, using default 0.15");
            compression = 0.15f;
            RDFInfo.setCompression(compression, specs);
        }
        return compression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countLines(String filename, RDFParserCallback parser, RDFNotation notation) throws FileNotFoundException, IOException, ParserException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename));){
            int readChars;
            byte[] c = new byte[1024];
            int count = 0;
            boolean empty = true;
            while ((readChars = ((InputStream)is).read(c)) != -1) {
                empty = false;
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
            }
            long l = count == 0 && !empty ? 1L : (long)count;
            return l;
        }
    }
}

