/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class StringUtil {
    private StringUtil() {
    }

    public static String getPercent(long v1, long max2) {
        if (max2 == 0L) {
            return "%";
        }
        return String.format("%.2f %%", 100.0 * (double)v1 / (double)max2);
    }

    public static String formatDate(Date date2) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date2);
    }

    public static String toHuman(long amount) {
        return StringUtil.humanReadableByteCount(amount, true);
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return Long.toString(bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f%c", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }
}

