/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.string;

import java.io.Serializable;
import java.util.Arrays;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.DelayedString;
import org.rdfhdt.hdt.util.string.ReplazableString;

public class CompactString
implements CharSequence,
Serializable,
Comparable<CompactString> {
    private static final long serialVersionUID = 6789858615261959413L;
    final byte[] data;
    private int hash;
    public static final CompactString EMPTY = new CompactString();

    private CompactString() {
        this.data = new byte[0];
    }

    public CompactString(ReplazableString str2) {
        this.data = Arrays.copyOf(str2.buffer, str2.used);
    }

    public CompactString(CompactString other) {
        this.data = Arrays.copyOf(other.data, other.data.length);
    }

    public CompactString(String other) {
        this.data = other.getBytes(ByteStringUtil.STRING_ENCODING);
    }

    public CompactString(CharSequence other) {
        this.data = other.toString().getBytes(ByteStringUtil.STRING_ENCODING);
    }

    public byte[] getData() {
        return this.data;
    }

    private CompactString(byte[] data) {
        this.data = data;
    }

    public int indexOf(char ch) {
        for (int i = 0; i < this.data.length; ++i) {
            if ((char)(this.data[i] & 0xFF) != ch) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        for (int i = this.data.length - 1; i >= 0; --i) {
            if ((char)(this.data[i] & 0xFF) != ch) continue;
            return i;
        }
        return -1;
    }

    @Override
    public char charAt(int index) {
        int ix = index;
        if (ix >= this.data.length) {
            throw new StringIndexOutOfBoundsException("Invalid index " + index + " length " + this.length());
        }
        return (char)(this.data[ix] & 0xFF);
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end > this.length() || end - start < 0) {
            throw new IllegalArgumentException("Illegal range " + start + "-" + end + " for sequence of length " + this.length());
        }
        byte[] newdata = new byte[end - start];
        System.arraycopy(this.data, start, newdata, 0, end - start);
        return new CompactString(newdata);
    }

    @Override
    public String toString() {
        return new String(this.data, 0, this.data.length, ByteStringUtil.STRING_ENCODING);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = -2128831035;
            int i = this.data.length;
            while (i-- != 0) {
                this.hash = this.hash * 16777619 ^ this.data[i];
            }
        }
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof CompactString) {
            CompactString cmp = (CompactString)o;
            if (this.data.length != cmp.data.length) {
                return false;
            }
            int i = this.data.length;
            while (i-- != 0) {
                if (this.data[i] == cmp.data[i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof CharSequence) {
            CharSequence other = (CharSequence)o;
            return this.length() == other.length() && CharSequenceComparator.getInstance().compare(this, other) == 0;
        }
        throw new NotImplementedException();
    }

    @Override
    public int compareTo(CompactString other) {
        int n = Math.min(this.data.length, other.data.length);
        for (int k = 0; k < n; ++k) {
            int c1 = this.data[k] & 0xFF;
            int c2 = other.data[k] & 0xFF;
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return this.data.length - other.data.length;
    }

    public CharSequence getDelayed() {
        return new DelayedString(this);
    }
}

