/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.util.UUID;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.dboe.sys.LibUUID;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.shared.uuid.JenaUUID;

public class TxnIdUuid
implements TxnId {
    private long mostSignificantBits;
    private long leastSignificantBits;
    private byte[] bytes = null;
    private String name = null;

    static TxnIdUuid create() {
        UUID id = JenaUUID.generate().asUUID();
        return new TxnIdUuid(id);
    }

    public static TxnIdUuid create(byte[] bytes) {
        long mostSignificantBits = Bytes.getLong(bytes, 0);
        long leastSignificantBits = Bytes.getLong(bytes, 8);
        return new TxnIdUuid(mostSignificantBits, leastSignificantBits);
    }

    TxnIdUuid(UUID id) {
        this.mostSignificantBits = id.getMostSignificantBits();
        this.leastSignificantBits = id.getLeastSignificantBits();
    }

    TxnIdUuid(long mostSig, long leastSig) {
        this.mostSignificantBits = mostSig;
        this.leastSignificantBits = leastSig;
    }

    @Override
    public String name() {
        if (this.name == null) {
            this.name = LibUUID.uuidToString(this.mostSignificantBits, this.leastSignificantBits);
        }
        return this.name;
    }

    @Override
    public byte[] bytes() {
        if (this.bytes == null) {
            this.bytes = LibUUID.uuidAsBytes(this.mostSignificantBits, this.leastSignificantBits);
        }
        return this.bytes;
    }

    @Override
    public long runtime() {
        return this.mostSignificantBits;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.leastSignificantBits ^ this.leastSignificantBits >>> 32);
        result = 31 * result + (int)(this.mostSignificantBits ^ this.mostSignificantBits >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TxnIdUuid other = (TxnIdUuid)obj;
        if (this.leastSignificantBits != other.leastSignificantBits) {
            return false;
        }
        return this.mostSignificantBits == other.mostSignificantBits;
    }

    public String toString() {
        return String.format("[%04X]", this.mostSignificantBits & 0xFFFFL);
    }
}

