/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Set;
import org.apache.jena.ext.com.google.common.collect.Multimap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ReportConstraint;
import org.apache.jena.shacl.engine.constraint.SparqlComponent;
import org.apache.jena.shacl.engine.constraint.SparqlValidation;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class ConstraintComponentSPARQL
implements Constraint {
    protected final SparqlComponent sparqlConstraintComponent;
    protected final Multimap<Parameter, Node> parameterMap;
    protected final Query query;

    public ConstraintComponentSPARQL(SparqlComponent sparqlConstraintComponent, Multimap<Parameter, Node> parameterMap) {
        this.sparqlConstraintComponent = sparqlConstraintComponent;
        this.parameterMap = parameterMap;
        String qs = sparqlConstraintComponent.getSparqlString();
        try {
            this.query = QueryFactory.create(sparqlConstraintComponent.getSparqlString());
            if (!this.query.isAskType() && !this.query.isSelectType()) {
                throw new ShaclParseException("Not a SELECT or ASK query");
            }
        }
        catch (QueryParseException ex) {
            throw new ShaclParseException("Bad query: " + ex.getMessage());
        }
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        SparqlValidation.validate(vCxt, data, shape, focusNode, null, focusNode, this.query, this.parameterMap, new ReportConstraint(this.sparqlConstraintComponent.getReportComponent()));
    }

    @Override
    public void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> valueNodes) {
        valueNodes.forEach(vn -> SparqlValidation.validate(vCxt, data, shape, focusNode, path, vn, this.query, this.parameterMap, new ReportConstraint(this.sparqlConstraintComponent.getReportComponent())));
    }

    @Override
    public Node getComponent() {
        return SHACL.SPARQLConstraintComponent;
    }

    public String toString() {
        if (this.sparqlConstraintComponent.isSelect()) {
            return "SELECT" + this.parameterMap;
        }
        return "ASK" + this.parameterMap;
    }
}

