/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.cli.io.output.format.gene_prioritized;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.vibe.cli.io.output.ValuesSeparator;
import org.molgenis.vibe.cli.io.output.format.PrioritizedOutputFormatWriter;
import org.molgenis.vibe.cli.io.output.target.OutputWriter;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.GeneDiseaseCombination;
import org.molgenis.vibe.core.formats.PubmedEvidence;

public abstract class ResultsPerGeneSeparatedValuesOutputFormatWriter
extends PrioritizedOutputFormatWriter<Gene> {
    private GeneDiseaseCollection collection;
    private ValuesSeparator primarySeparator;
    private ValuesSeparator keyValuePairSeparator;
    private ValuesSeparator keyValueSeparator;
    private ValuesSeparator valuesSeparator;

    public ResultsPerGeneSeparatedValuesOutputFormatWriter(OutputWriter writer, List<Gene> priority, GeneDiseaseCollection collection, ValuesSeparator primarySeparator, ValuesSeparator keyValuePairSeparator, ValuesSeparator keyValueSeparator, ValuesSeparator valuesSeparator) {
        super(writer, priority);
        this.collection = Objects.requireNonNull(collection);
        this.primarySeparator = Objects.requireNonNull(primarySeparator);
        this.keyValuePairSeparator = Objects.requireNonNull(keyValuePairSeparator);
        this.keyValueSeparator = Objects.requireNonNull(keyValueSeparator);
        this.valuesSeparator = Objects.requireNonNull(valuesSeparator);
        HashSet<ValuesSeparator> separators = new HashSet<ValuesSeparator>();
        separators.add(primarySeparator);
        separators.add(keyValuePairSeparator);
        separators.add(keyValueSeparator);
        separators.add(valuesSeparator);
        if (separators.size() < 4) {
            throw new IllegalArgumentException("the separators cannot be the same");
        }
    }

    @Override
    public void generateOutput() throws IOException {
        this.getOutputWriter().writeHeader("gene (NCBI)" + (Object)((Object)this.primarySeparator) + "gene symbol (derived from NCBI)" + (Object)((Object)this.primarySeparator) + "highest GDA score" + (Object)((Object)this.primarySeparator) + "diseases (UMLS) with sources per disease");
        this.getOutputWriter().writeNewLine();
        for (Gene gene : this.getPriority()) {
            this.getOutputWriter().write(this.writeGene(gene) + (Object)((Object)this.primarySeparator) + this.writeGeneSymbol(gene) + (Object)((Object)this.primarySeparator));
            List<GeneDiseaseCombination> geneDiseaseCombinations = this.collection.getByGeneOrderedByGdaScore(gene);
            for (int i = 0; i < geneDiseaseCombinations.size(); ++i) {
                GeneDiseaseCombination gdc = geneDiseaseCombinations.get(i);
                if (i == 0) {
                    this.getOutputWriter().write(Double.toString(gdc.getDisgenetScore()) + (Object)((Object)this.primarySeparator));
                } else {
                    this.getOutputWriter().write(this.keyValuePairSeparator.toString());
                }
                this.getOutputWriter().write(this.writeDisease(gdc.getDisease()));
                this.getOutputWriter().write(" (" + gdc.getDisgenetScore() + ")");
                ArrayList<PubmedEvidence> pubmedEvidenceList = new ArrayList<PubmedEvidence>(gdc.getAllPubmedEvidence());
                if (pubmedEvidenceList.isEmpty()) continue;
                Collections.sort(pubmedEvidenceList, PubmedEvidence.RELEASE_YEAR_COMPARATOR);
                String evidence = StringUtils.join(this.writeEvidence(pubmedEvidenceList), this.valuesSeparator.toString());
                this.getOutputWriter().write((Object)((Object)this.keyValueSeparator) + evidence);
            }
            this.getOutputWriter().writeNewLine();
        }
    }

    protected abstract String writeGene(Gene var1) throws IOException;

    protected abstract String writeGeneSymbol(Gene var1) throws IOException;

    protected abstract String writeDisease(Disease var1) throws IOException;

    protected abstract List<String> writeEvidence(List<PubmedEvidence> var1) throws IOException;
}

