/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.formats.PhenotypeNetwork;

public class PhenotypeNetworkCollection {
    private Map<Phenotype, PhenotypeNetwork> phenotypeNetworks = new HashMap<Phenotype, PhenotypeNetwork>();

    public Set<Phenotype> getPhenotypes() {
        HashSet<Phenotype> phenotypes = new HashSet<Phenotype>();
        for (PhenotypeNetwork network : this.phenotypeNetworks.values()) {
            phenotypes.addAll(network.getPhenotypes());
        }
        return phenotypes;
    }

    public PhenotypeNetwork getPhenotypeNetworkBySource(Phenotype source) {
        return this.phenotypeNetworks.get(source);
    }

    public void add(PhenotypeNetwork network) {
        this.phenotypeNetworks.put(network.getSource(), network);
    }

    public boolean remove(PhenotypeNetwork network) {
        return this.phenotypeNetworks.values().remove(network);
    }

    public PhenotypeNetwork remove(Phenotype phenotypeSource) {
        return this.phenotypeNetworks.remove(phenotypeSource);
    }

    public void clear() {
        this.phenotypeNetworks.clear();
    }

    public String toString() {
        return "PhenotypeNetworkCollection{phenotypeNetworks=" + this.phenotypeNetworks + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhenotypeNetworkCollection that = (PhenotypeNetworkCollection)o;
        return Objects.equals(this.phenotypeNetworks, that.phenotypeNetworks);
    }

    public int hashCode() {
        return Objects.hash(this.phenotypeNetworks);
    }
}

