/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.sequence;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Iterator;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;

public class SequenceLog64Map
implements Sequence,
Closeable {
    private static final byte W = 64;
    private static final long LONGS_PER_BUFFER = 0x8000000L;
    private ByteBuffer[] buffers;
    private FileChannel ch;
    private int numbits;
    private long numentries;
    private long lastword;
    private long numwords;

    public SequenceLog64Map(File f) throws IOException {
        this(new CountInputStream(new BufferedInputStream(new FileInputStream(f))), f, true);
    }

    public SequenceLog64Map(CountInputStream in, File f) throws IOException {
        this(in, f, false);
    }

    private SequenceLog64Map(CountInputStream in, File f, boolean closeInput) throws IOException {
        CRCInputStream crcin = new CRCInputStream(in, new CRC8());
        int type = crcin.read();
        if (type != 1) {
            throw new IllegalFormatException("Trying to read a LogArray but the data is not LogArray");
        }
        this.numbits = crcin.read();
        this.numentries = VByte.decode(crcin);
        if (!crcin.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading LogArray64 header.");
        }
        if (this.numbits > 64) {
            throw new IllegalFormatException("LogArray64 cannot deal with more than 64bit per entry");
        }
        long base = in.getTotalBytes();
        this.numwords = SequenceLog64.numWordsFor(this.numbits, this.numentries);
        if (this.numwords > 0L) {
            IOUtil.skip(in, (this.numwords - 1L) * 8L);
            int lastWordUsed = SequenceLog64.lastWordNumBits(this.numbits, this.numentries);
            this.lastword = BitUtil.readLowerBitsByteAligned(lastWordUsed, in);
        }
        IOUtil.skip(in, 4L);
        this.mapFiles(f, base);
        if (closeInput) {
            in.close();
        }
    }

    public SequenceLog64Map(int numbits, long numentries, File f) throws IOException {
        this.numbits = numbits;
        this.numentries = numentries;
        this.numwords = SequenceLog64.numWordsFor(numbits, numentries);
        this.mapFiles(f, 0L);
    }

    private void mapFiles(File f, long base) throws IOException {
        this.ch = FileChannel.open(Paths.get(f.toString(), new String[0]), new OpenOption[0]);
        long maxSize = base + SequenceLog64.numBytesFor(this.numbits, this.numentries);
        int buffer = 0;
        long block = 0L;
        this.buffers = new ByteBuffer[(int)(1L + this.numwords / 0x8000000L)];
        while (block < this.numwords) {
            long current = base + (long)buffer * 8L * 0x8000000L;
            long next = current + 0x40000000L;
            long length = Math.min(maxSize, next) - current;
            this.buffers[buffer] = this.ch.map(FileChannel.MapMode.READ_ONLY, current, length);
            this.buffers[buffer].order(ByteOrder.LITTLE_ENDIAN);
            block += 0x8000000L;
            ++buffer;
        }
        CountInputStream in = new CountInputStream(new BufferedInputStream(new FileInputStream(f)));
        IOUtil.skip(in, base + (this.numwords - 1L) * 8L);
        int lastWordUsedBits = SequenceLog64.lastWordNumBits(this.numbits, this.numentries);
        this.lastword = BitUtil.readLowerBitsByteAligned(lastWordUsedBits, in);
        in.close();
    }

    private long getWord(long w) {
        if (w == this.numwords - 1L) {
            return this.lastword;
        }
        ByteBuffer buffer = this.buffers[(int)(w / 0x8000000L)];
        return buffer.getLong((int)(w % 0x8000000L * 8L));
    }

    @Override
    public long get(long index) {
        long result;
        if (index < 0L || index >= this.numentries) {
            throw new IndexOutOfBoundsException();
        }
        if (this.numbits == 0) {
            return 0L;
        }
        long bitPos = index * (long)this.numbits;
        long i = bitPos / 64L;
        int j = (int)(bitPos % 64L);
        if (j + this.numbits <= 64) {
            result = this.getWord(i) << 64 - j - this.numbits >>> 64 - this.numbits;
        } else {
            result = this.getWord(i) >>> j;
            result |= this.getWord(i + 1L) << 128 - j - this.numbits >>> 64 - this.numbits;
        }
        return result;
    }

    @Override
    public long getNumberOfElements() {
        return this.numentries;
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(1);
        out.write(this.numbits);
        VByte.encode(out, this.numentries);
        out.writeCRC();
        out.setCRC(new CRC32());
        long numwords = SequenceLog64.numWordsFor(this.numbits, this.numentries);
        for (long i = 0L; i < numwords - 1L; ++i) {
            IOUtil.writeLong(out, this.getWord(i));
        }
        if (numwords > 0L) {
            long lastWordUsedBits = SequenceLog64.lastWordNumBits(this.numbits, this.numentries);
            BitUtil.writeLowerBitsByteAligned(this.lastword, lastWordUsedBits, out);
        }
        out.writeCRC();
    }

    @Override
    public long size() {
        return SequenceLog64.numBytesFor(this.numbits, this.numentries);
    }

    public int getNumBits() {
        return this.numbits;
    }

    @Override
    public String getType() {
        return "<http://purl.org/HDT/hdt#seqLog>";
    }

    @Override
    public void add(Iterator<Long> elements) {
        throw new NotImplementedException();
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public void close() throws IOException {
        this.buffers = null;
        this.ch.close();
    }
}

