/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.impl.BaseDictionary;
import org.rdfhdt.hdt.dictionary.impl.section.DictionarySectionFactory;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySection;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.listener.IntermediateListener;

public class FourSectionDictionary
extends BaseDictionary {
    public FourSectionDictionary(HDTOptions spec, DictionarySectionPrivate s, DictionarySectionPrivate p, DictionarySectionPrivate o, DictionarySectionPrivate sh) {
        super(spec);
        this.subjects = s;
        this.predicates = p;
        this.objects = o;
        this.shared = sh;
    }

    public FourSectionDictionary(HDTOptions spec) {
        super(spec);
        this.subjects = new PFCDictionarySection(spec);
        this.predicates = new PFCDictionarySection(spec);
        this.objects = new PFCDictionarySection(spec);
        this.shared = new PFCDictionarySection(spec);
    }

    @Override
    public void load(TempDictionary other, ProgressListener listener) {
        IntermediateListener iListener = new IntermediateListener(listener);
        this.subjects.load(other.getSubjects(), (ProgressListener)iListener);
        this.predicates.load(other.getPredicates(), (ProgressListener)iListener);
        this.objects.load(other.getObjects(), (ProgressListener)iListener);
        this.shared.load(other.getShared(), (ProgressListener)iListener);
    }

    @Override
    public void save(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat(this.getType());
        ci.setInt("elements", this.getNumberOfElements());
        ci.save(output);
        IntermediateListener iListener = new IntermediateListener(listener);
        this.shared.save(output, iListener);
        this.subjects.save(output, iListener);
        this.predicates.save(output, iListener);
        this.objects.save(output, iListener);
    }

    @Override
    public void load(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
        if (ci.getType() != ControlInfo.Type.DICTIONARY) {
            throw new IllegalFormatException("Trying to read a dictionary section, but was not dictionary.");
        }
        IntermediateListener iListener = new IntermediateListener(listener);
        this.shared = DictionarySectionFactory.loadFrom(input, iListener);
        this.subjects = DictionarySectionFactory.loadFrom(input, iListener);
        this.predicates = DictionarySectionFactory.loadFrom(input, iListener);
        this.objects = DictionarySectionFactory.loadFrom(input, iListener);
    }

    @Override
    public void mapFromFile(CountInputStream in, File f, ProgressListener listener) throws IOException {
        ControlInformation ci = new ControlInformation();
        ci.load(in);
        if (ci.getType() != ControlInfo.Type.DICTIONARY) {
            throw new IllegalFormatException("Trying to read a dictionary section, but was not dictionary.");
        }
        IntermediateListener iListener = new IntermediateListener(listener);
        this.shared = DictionarySectionFactory.loadFrom(in, f, iListener);
        this.subjects = DictionarySectionFactory.loadFrom(in, f, iListener);
        this.predicates = DictionarySectionFactory.loadFrom(in, f, iListener);
        this.objects = DictionarySectionFactory.loadFrom(in, f, iListener);
    }

    @Override
    public void populateHeader(Header header, String rootNode) {
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/dc/terms/format>", this.getType());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionarynumSharedSubjectObject>", this.getNshared());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionarysizeStrings>", this.size());
    }

    @Override
    public String getType() {
        return "<http://purl.org/HDT/hdt#dictionaryFour>";
    }

    @Override
    public void close() throws IOException {
        this.shared.close();
        this.subjects.close();
        this.predicates.close();
        this.objects.close();
    }
}

