/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.header;

import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.header.PlainHeader;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TripleString;

public class PlainHeaderIterator
implements IteratorTripleString {
    private final PlainHeader header;
    private int pos;
    private TripleString nextTriple;
    private final TripleString pattern;
    private TripleString returnTriple;
    private boolean hasMoreTriples;

    public PlainHeaderIterator(PlainHeader header, TripleString pattern) {
        this.header = header;
        this.pattern = pattern;
        this.pos = 0;
        this.doFetch();
    }

    private void doFetch() {
        do {
            this.getNextTriple();
        } while (this.hasMoreTriples && !this.nextTriple.match(this.pattern));
    }

    private void getNextTriple() {
        if (this.pos < this.header.triples.size()) {
            this.nextTriple = this.header.triples.get(this.pos);
        }
        ++this.pos;
        this.hasMoreTriples = this.pos <= this.header.triples.size();
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreTriples;
    }

    @Override
    public TripleString next() {
        this.returnTriple = this.nextTriple;
        this.doFetch();
        return this.returnTriple;
    }

    @Override
    public void goToStart() {
        this.pos = 0;
        this.doFetch();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long estimatedNumResults() {
        return this.header.triples.size();
    }

    @Override
    public ResultEstimationType numResultEstimation() {
        return ResultEstimationType.UP_TO;
    }
}

