/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;
import org.rdfhdt.hdt.util.io.IOUtil;

public class RDFParserList
implements RDFParserCallback {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doParse(String fileName, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        BufferedReader reader;
        try {
            reader = IOUtil.getFileReader(fileName);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new ParserException(e2);
        }
        try {
            this.doParse(reader, baseUri, notation, callback);
        }
        finally {
            IOUtil.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doParse(InputStream input, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        try {
            this.doParse(reader, baseUri, notation, callback);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void doParse(BufferedReader reader, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                System.out.println(line);
                RDFNotation guessnot = RDFNotation.guess(line);
                System.out.println("Parse from list: " + line + " as " + (Object)((Object)guessnot));
                RDFParserCallback parser = RDFParserFactory.getParserCallback(guessnot);
                parser.doParse(line, baseUri, guessnot, callback);
            }
            reader.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ParserException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getList(String file) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader reader = IOUtil.getFileReader(file);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                list.add(line);
            }
        }
        return list;
    }
}

