/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.prefixes;

import java.util.Map;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.dboe.storage.prefixes.PrefixMapI;
import org.apache.jena.shared.PrefixMapping;

public class PrefixMappingOverPrefixMapI
implements PrefixMapping {
    private PrefixMapI pmap;

    PrefixMappingOverPrefixMapI(PrefixMapI pmap) {
        this.pmap = pmap;
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.pmap.add(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.pmap.delete(prefix);
        return this;
    }

    @Override
    public PrefixMapping clearNsPrefixMap() {
        this.pmap.clear();
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        for (Map.Entry<String, String> e2 : map.entrySet()) {
            String prefix = e2.getKey();
            String iriStr = e2.getValue();
            this.pmap.add(prefix, iriStr);
        }
        return this;
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        Map<String, String> emap = map.getNsPrefixMap();
        for (Map.Entry<String, String> e2 : emap.entrySet()) {
            String prefix = e2.getKey();
            String iriStr = e2.getValue();
            if (this.pmap.containPrefix(prefix)) continue;
            this.pmap.add(prefix, iriStr);
        }
        return this;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        return this.pmap.getMapping().get(prefix);
    }

    @Override
    public String getNsURIPrefix(String uri) {
        Pair<String, String> abbrev = this.pmap.abbrev(uri);
        if (abbrev == null) {
            return null;
        }
        return abbrev.getLeft();
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return this.pmap.getMappingCopy();
    }

    @Override
    public String expandPrefix(String prefixed) {
        String str2 = this.pmap.expand(prefixed);
        if (str2 == null) {
            return prefixed;
        }
        return str2;
    }

    @Override
    public String shortForm(String uri) {
        String s = this.pmap.abbreviate(uri);
        if (s == null) {
            return uri;
        }
        return s;
    }

    @Override
    public String qnameFor(String uri) {
        return this.pmap.abbreviate(uri);
    }

    @Override
    public boolean hasNoMappings() {
        return this.pmap.isEmpty();
    }

    @Override
    public int numPrefixes() {
        return this.pmap.size();
    }

    @Override
    public PrefixMapping lock() {
        return this;
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.getNsPrefixMap().equals(other.getNsPrefixMap());
    }

    public String toString() {
        return "PrefixMappingOverPrefixMapI:" + this.pmap.toString();
    }
}

