/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.exec;

import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.sparql.path.Path;

public class ValidationOp {
    private final Shape shape;
    private final Target target;
    private final Path path;
    private final Constraint constraint;

    public ValidationOp(Shape shape, Target target, Path path, Constraint constraint) {
        this.shape = shape;
        this.target = target;
        this.path = path;
        this.constraint = constraint;
    }

    public String toString() {
        return String.format("%s :: %s :: %s :: %s", this.shape.toString(), this.target, this.path == null ? "----" : ShaclPaths.pathToString(this.shape.getShapeGraph(), this.path), this.constraint);
    }

    public Shape getShape() {
        return this.shape;
    }

    public Target getTarget() {
        return this.target;
    }

    public Path getPath() {
        return this.path;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }
}

