/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.lib.G;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.NodeShape;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.vocabulary.RDF;

public class ValidationProc {
    private static IndentedWriter out = IndentedWriter.stdout;

    public static ValidationReport simpleValidatation(Graph shapesGraph, Graph data) {
        return ValidationProc.simpleValidatation(shapesGraph, data, false);
    }

    public static ValidationReport simpleValidatation(Graph shapesGraph, Graph data, boolean verbose) {
        Shapes shapes = Shapes.parse(shapesGraph);
        return ValidationProc.simpleValidatation(shapes, data, verbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationReport simpleValidatation(Shapes shapes, Graph data, boolean verbose) {
        int x = out.getAbsoluteIndent();
        try {
            ValidationContext vCxt = new ValidationContext(shapes, data);
            vCxt.setVerbose(verbose);
            ValidationReport validationReport = ValidationProc.simpleValidatation(vCxt, shapes, data);
            return validationReport;
        }
        finally {
            out.setAbsoluteIndent(x);
        }
    }

    public static ValidationReport simpleValidatation(ValidationContext vCxt, Iterable<Shape> shapes, Graph data) {
        for (Shape shape : shapes) {
            ValidationProc.simpleValidatation(vCxt, data, shape);
        }
        if (vCxt.isVerbose()) {
            out.ensureStartOfLine();
        }
        return vCxt.generateReport();
    }

    public static void simpleValidatation(ValidationContext vCxt, Graph data, Shape shape) {
        ValidationProc.simpleValidatationInternal(vCxt, data, null, shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationReport simpleValidatationNode(Shapes shapes, Graph data, Node node, boolean verbose) {
        int x = out.getAbsoluteIndent();
        try {
            ValidationContext vCxt = new ValidationContext(shapes, data);
            vCxt.setVerbose(verbose);
            ValidationReport validationReport = ValidationProc.simpleValidatationNode(vCxt, shapes, node, data);
            return validationReport;
        }
        finally {
            out.setAbsoluteIndent(x);
        }
    }

    private static ValidationReport simpleValidatationNode(ValidationContext vCxt, Shapes shapes, Node node, Graph data) {
        for (Shape shape : shapes) {
            ValidationProc.simpleValidatationNode(vCxt, data, node, shape);
        }
        if (vCxt.isVerbose()) {
            out.ensureStartOfLine();
        }
        return vCxt.generateReport();
    }

    private static void simpleValidatationNode(ValidationContext vCxt, Graph data, Node node, Shape shape) {
        ValidationProc.simpleValidatationInternal(vCxt, data, node, shape);
    }

    private static void simpleValidatationInternal(ValidationContext vCxt, Graph data, Node node, Shape shape) {
        Collection<Node> focusNodes = ValidationProc.getFocusNodes(data, shape);
        if (node != null) {
            if (!focusNodes.contains(node)) {
                return;
            }
            focusNodes = Collections.singleton(node);
        }
        if (vCxt.isVerbose()) {
            out.println(shape.toString());
            out.printf("N: FocusNodes(%d): %s\n", focusNodes.size(), focusNodes);
            out.incIndent();
        }
        for (Node focusNode : focusNodes) {
            if (vCxt.isVerbose()) {
                out.println("F: " + focusNode);
            }
            ValidationProc.validateShape(vCxt, data, shape, focusNode);
        }
        if (vCxt.isVerbose()) {
            out.decIndent();
        }
    }

    public static void execValidateShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        ValidationProc.validateShape(vCxt, data, shape, focusNode);
    }

    private static void validateShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        Set<Node> vNodes;
        Path path;
        if (shape.deactivated()) {
            return;
        }
        if (vCxt.isVerbose()) {
            out.println("S: " + shape);
        }
        if (shape instanceof NodeShape) {
            path = null;
            vNodes = null;
        } else if (shape instanceof PropertyShape) {
            PropertyShape propertyShape = (PropertyShape)shape;
            path = propertyShape.getPath();
            vNodes = ShaclPaths.valueNodes(data, focusNode, propertyShape.getPath());
        } else {
            if (vCxt.isVerbose()) {
                out.println("Z: " + shape);
            }
            return;
        }
        for (Constraint c : shape.getConstraints()) {
            if (vCxt.isVerbose()) {
                out.println("C: " + c);
            }
            ValidationProc.evalConstraint(vCxt, data, shape, focusNode, path, vNodes, c);
        }
        ValidationProc.validationPropertyShapes(vCxt, data, shape.getPropertyShapes(), focusNode);
        if (vCxt.isVerbose()) {
            out.println();
        }
    }

    private static void validationPropertyShapes(ValidationContext vCxt, Graph data, List<PropertyShape> propertyShapes, Node focusNode) {
        if (propertyShapes == null) {
            return;
        }
        for (PropertyShape propertyShape : propertyShapes) {
            ValidationProc.validationPropertyShape(vCxt, data, propertyShape, focusNode);
        }
    }

    private static void validationPropertyShape(ValidationContext vCxt, Graph data, PropertyShape propertyShape, Node focusNode) {
        if (propertyShape.deactivated()) {
            return;
        }
        if (vCxt.isVerbose()) {
            out.println("P: " + propertyShape);
        }
        Set<Node> vNodes = ShaclPaths.valueNodes(data, focusNode, propertyShape.getPath());
        for (Constraint c : propertyShape.getConstraints()) {
            if (vCxt.isVerbose()) {
                out.println("C: " + focusNode + " :: " + c);
            }
            ValidationProc.evalConstraint(vCxt, data, propertyShape, focusNode, propertyShape.getPath(), vNodes, c);
        }
        vNodes.forEach(vNode -> ValidationProc.validationPropertyShapes(vCxt, data, propertyShape.getPropertyShapes(), vNode));
    }

    private static void evalConstraint(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> pathNodes, Constraint c) {
        if (path == null) {
            if (pathNodes != null) {
                throw new InternalErrorException("Path is null but pathNodes is not null");
            }
            c.validateNodeShape(vCxt, data, shape, focusNode);
            return;
        }
        if (pathNodes == null) {
            throw new InternalErrorException("Path is not null but pathNodes is null");
        }
        c.validatePropertyShape(vCxt, data, shape, focusNode, path, pathNodes);
    }

    private static Collection<Node> getFocusNodes(Graph data, Shape shape) {
        HashSet<Node> acc = new HashSet<Node>();
        shape.getTargets().forEach(target -> acc.addAll(ValidationProc.getFocusNodes(data, shape, target)));
        return acc;
    }

    private static Collection<Node> getFocusNodes(Graph data, Shape shape, Target target) {
        Node targetObj = target.getObject();
        switch (target.getTargetType()) {
            case targetClass: {
                return G.listPO(data, RDF.Nodes.type, targetObj);
            }
            case targetNode: {
                return Collections.singletonList(targetObj);
            }
            case targetObjectsOf: {
                return G.setSP(data, null, targetObj);
            }
            case targetSubjectsOf: {
                return G.setPO(data, targetObj, null);
            }
            case implicitClass: {
                return G.listAllNodesOfType(data, targetObj);
            }
        }
        return Collections.emptyList();
    }
}

