/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggMode
extends AggregatorBase {
    private static Logger log = LoggerFactory.getLogger("MODE");
    private static final NodeValue noValuesToMode = NodeValue.nvZERO;

    public AggMode(Expr expr) {
        super("MODE", false, expr);
    }

    @Override
    public Aggregator copy(ExprList expr) {
        return new AggMode(expr.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccMode(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToMode);
    }

    @Override
    public int hashCode() {
        return 0x184 ^ this.getExprList().hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggMode)) {
            return false;
        }
        AggMode a = (AggMode)other;
        return this.exprList.equals(a.exprList, bySyntax);
    }

    private static class AccMode
    extends AccumulatorExpr {
        private NodeValue total = AggMode.access$000();
        private int count = 0;
        ArrayList<NodeValue> collection = new ArrayList();

        public AccMode(Expr expr) {
            super(expr, false);
        }

        @Override
        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            log.debug("mode {}", (Object)nv);
            if (nv.isNumber()) {
                ++this.count;
            } else {
                throw new ExprEvalException("mode: not a number: " + nv);
            }
            this.collection.add(nv);
            log.debug("mode count {}", (Object)this.count);
        }

        @Override
        public NodeValue getAccValue() {
            double mode = Double.NaN;
            if (this.count == 0) {
                return noValuesToMode;
            }
            if (this.errorCount != 0L) {
                return null;
            }
            int indexsize = this.collection.size();
            double[] arrDouble = new double[indexsize];
            for (int i = 0; i < indexsize; ++i) {
                arrDouble[i] = this.collection.get(i).getDouble();
            }
            HashMap<Double, Integer> amode = new HashMap<Double, Integer>();
            int max2 = 0;
            for (int i = 0; i < arrDouble.length; ++i) {
                if (amode.get(arrDouble[i]) != null) {
                    int count = (Integer)amode.get(arrDouble[i]);
                    amode.put(arrDouble[i], ++count);
                    if (count <= max2) continue;
                    max2 = count;
                    mode = arrDouble[i];
                    continue;
                }
                amode.put(arrDouble[i], 1);
                if (mode != 0.0) continue;
                mode = arrDouble[i];
            }
            return NodeValue.makeDecimal(mode);
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }
    }
}

