/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.cli.io.output.target;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.molgenis.vibe.cli.io.output.target.OutputWriter;

public class FileOutputWriter
implements OutputWriter {
    private Path path;
    private BufferedWriter writer;

    public Path getPath() {
        return this.path;
    }

    public FileOutputWriter(Path path) {
        this.path = Objects.requireNonNull(path);
    }

    @Override
    public String target() {
        return this.getPath().toString();
    }

    @Override
    public void initialize() throws IOException {
        if (this.writer == null) {
            this.writer = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
    }

    @Override
    public void write(String output) throws IOException {
        this.writer.write(output);
    }

    @Override
    public void writeHeader(String output) throws IOException {
        this.writer.write(output);
    }

    @Override
    public void writeNewLine() throws IOException {
        this.writer.newLine();
    }
}

