/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.molgenis.vibe.core.formats.Phenotype;

public class PhenotypeNetwork {
    private Map<Phenotype, Integer> items = new HashMap<Phenotype, Integer>();
    private Map<Integer, Set<Phenotype>> network = new HashMap<Integer, Set<Phenotype>>();

    public PhenotypeNetwork(Phenotype phenotype) {
        this.items.put(phenotype, 0);
        HashSet<Phenotype> sourceSet = new HashSet<Phenotype>();
        sourceSet.add(Objects.requireNonNull(phenotype));
        this.network.put(0, sourceSet);
    }

    public Phenotype getSource() {
        return this.network.get(0).iterator().next();
    }

    public Set<Phenotype> getPhenotypes() {
        return Collections.unmodifiableSet(this.items.keySet());
    }

    public Set<Integer> getDistances() {
        return Collections.unmodifiableSet(this.network.keySet());
    }

    public Set<Phenotype> getByDistance(int distance) {
        return Collections.unmodifiableSet(this.network.get(distance));
    }

    public int getDistance(Phenotype phenotype) {
        return this.items.get(phenotype);
    }

    public void add(Collection<Phenotype> phenotypes, int distance) {
        Iterator<Phenotype> it = phenotypes.iterator();
        while (it.hasNext()) {
            this.add(it.next(), distance);
        }
    }

    public boolean add(Phenotype phenotype, int distance) {
        if (distance == 0) {
            if (phenotype.equals(this.getSource())) {
                return false;
            }
            throw new IllegalArgumentException("The given phenotype with distance 0 does not equal the source phenotype.");
        }
        Integer retrievedPhenotypeDistance = this.items.get(phenotype);
        if (retrievedPhenotypeDistance == null) {
            this.items.put(phenotype, distance);
            this.getPhenotypesForDistance(distance).add(phenotype);
            return true;
        }
        if (retrievedPhenotypeDistance <= distance) {
            return false;
        }
        this.items.put(phenotype, distance);
        this.getPhenotypesForDistance(retrievedPhenotypeDistance).remove(phenotype);
        this.getPhenotypesForDistance(distance).add(phenotype);
        return true;
    }

    private Set<Phenotype> getPhenotypesForDistance(int distance) {
        return this.network.computeIfAbsent(distance, k -> new HashSet());
    }

    public boolean contains(Phenotype phenotype) {
        return this.items.keySet().contains(phenotype);
    }

    public String toString() {
        return "PhenotypeNetwork{network=" + this.network + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhenotypeNetwork that = (PhenotypeNetwork)o;
        return Objects.equals(this.network, that.network);
    }

    public int hashCode() {
        return Objects.hash(this.network);
    }
}

