/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCombination;
import org.molgenis.vibe.core.formats.GeneSymbol;
import org.molgenis.vibe.core.formats.PubmedEvidence;
import org.molgenis.vibe.core.formats.Source;
import org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection.GeneDiseaseCollectionJsonSerialization;

abstract class GeneDiseaseCollectionJsonDeserializer
extends GeneDiseaseCollectionJsonSerialization {
    GeneDiseaseCollectionJsonDeserializer() {
    }

    private static JsonPrimitive retrieveJsonPrimitive(JsonObject jsonObject, String key, boolean nullAllowed) {
        JsonPrimitive jsonPrimitive = jsonObject.getAsJsonPrimitive(key);
        return nullAllowed ? jsonPrimitive : (JsonPrimitive)GeneDiseaseCollectionJsonDeserializer.ensureNonNull(jsonPrimitive, key);
    }

    private static JsonArray retrieveJsonArray(JsonObject jsonObject, String key, boolean nullAllowed) {
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        return nullAllowed ? jsonArray : (JsonArray)GeneDiseaseCollectionJsonDeserializer.ensureNonNull(jsonArray, key);
    }

    private static JsonElement ensureNonNull(JsonElement element, String key) {
        if (element == null) {
            throw new JsonParseException("Expected field is missing: " + key);
        }
        return element;
    }

    static GeneDiseaseCombination deserializeGeneDiseaseCombination(JsonObject combinationObject, Map<String, Gene> genesMap, Map<String, Disease> diseasesMap, Map<String, Source> sourcesMap) {
        GeneDiseaseCombination geneDiseaseCombination = GeneDiseaseCollectionJsonDeserializer.generateGeneDiseaseCombination(combinationObject, genesMap, diseasesMap);
        GeneDiseaseCollectionJsonDeserializer.addSourcesToGeneDiseaseCombination(combinationObject, geneDiseaseCombination, sourcesMap);
        return geneDiseaseCombination;
    }

    private static GeneDiseaseCombination generateGeneDiseaseCombination(JsonObject combinationObject, Map<String, Gene> genesMap, Map<String, Disease> diseasesMap) {
        String geneString = GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(combinationObject, "ncbigene", false).getAsString();
        String diseaseString = GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(combinationObject, "umls", false).getAsString();
        Gene gene = genesMap.get(geneString);
        Disease disease = diseasesMap.get(diseaseString);
        if (gene == null && disease == null) {
            throw new JsonParseException("Missing gene and disease data belonging to a GeneDiseaseCombination: " + geneString + " & " + diseaseString);
        }
        if (gene == null) {
            throw new JsonParseException("Missing a gene data belonging to a GeneDiseaseCombination: " + geneString);
        }
        if (disease == null) {
            throw new JsonParseException("Missing a disease data belonging to a GeneDiseaseCombination: " + diseaseString);
        }
        JsonPrimitive jsonDisgenetScore = GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(combinationObject, "score", true);
        if (jsonDisgenetScore != null) {
            return new GeneDiseaseCombination(gene, disease, jsonDisgenetScore.getAsDouble());
        }
        return new GeneDiseaseCombination(gene, disease);
    }

    private static void addSourcesToGeneDiseaseCombination(JsonObject combinationObject, GeneDiseaseCombination geneDiseaseCombination, Map<String, Source> sourcesMap) {
        JsonArray combinationSourcesArray = GeneDiseaseCollectionJsonDeserializer.retrieveJsonArray(combinationObject, "sources", true);
        if (combinationSourcesArray != null) {
            Iterator<JsonElement> combinationSourcesIterator = combinationSourcesArray.iterator();
            while (combinationSourcesIterator.hasNext()) {
                JsonObject sourceObject = combinationSourcesIterator.next().getAsJsonObject();
                String sourceName = GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(sourceObject, "name", false).getAsString();
                Source source = sourcesMap.get(sourceName);
                if (source == null) {
                    throw new JsonParseException("Missing source data belonging to a GeneDiseaseCombination: " + sourceName);
                }
                int sourceCount = GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(sourceObject, "count", false).getAsInt();
                HashSet<PubmedEvidence> pubmedEvidenceForSource = new HashSet<PubmedEvidence>();
                Iterator<JsonElement> pubmedsIterator = GeneDiseaseCollectionJsonDeserializer.retrieveJsonArray(sourceObject, "pubmed", false).iterator();
                while (pubmedsIterator.hasNext()) {
                    JsonObject pubmedObject = pubmedsIterator.next().getAsJsonObject();
                    URI pubmedUri = URI.create(GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(pubmedObject, "uri", false).getAsString());
                    int pubmedYear = GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(pubmedObject, "year", false).getAsInt();
                    pubmedEvidenceForSource.add(new PubmedEvidence(pubmedUri, pubmedYear));
                }
                if (pubmedEvidenceForSource.isEmpty()) {
                    geneDiseaseCombination.set(source, sourceCount);
                    continue;
                }
                geneDiseaseCombination.set(source, sourceCount, pubmedEvidenceForSource);
            }
        }
    }

    static Gene deserializeGene(JsonObject jsonObject, String geneId) {
        String fullGeneId = "ncbigene:" + geneId;
        String fullGeneSymbolId = "hgnc:" + GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(jsonObject, "hgnc", false).getAsString();
        return new Gene(fullGeneId, new GeneSymbol(fullGeneSymbolId));
    }

    static Disease deserializeDisease(JsonObject jsonObject, String diseaseId) {
        String fullDiseaseId = "umls:" + diseaseId;
        String diseaseName = GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(jsonObject, "name", false).getAsString();
        return new Disease(fullDiseaseId, diseaseName);
    }

    static Source deserializeSource(JsonObject jsonObject, String sourceName) {
        String levelString;
        String sourceFullName;
        URI sourceUri = URI.create(GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(jsonObject, "uri", false).getAsString());
        Source source = new Source(sourceUri, sourceFullName = GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(jsonObject, "fullName", false).getAsString(), levelString = GeneDiseaseCollectionJsonDeserializer.retrieveJsonPrimitive(jsonObject, "level", false).getAsString());
        if (!source.getName().equals(sourceName)) {
            throw new JsonParseException("The source name is not equal to the one that is derived from the fullName.");
        }
        return source;
    }
}

