/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.Source;
import org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection.GeneDiseaseCollectionJsonDeserializer;

public class GeneDiseaseCollectionJsonMemoryDeserializer
extends GeneDiseaseCollectionJsonDeserializer
implements JsonDeserializer<GeneDiseaseCollection> {
    @Override
    public GeneDiseaseCollection deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context2) throws JsonParseException {
        JsonObject collectionObject = json.getAsJsonObject();
        return GeneDiseaseCollectionJsonMemoryDeserializer.deserializeGeneDiseaseCollection(collectionObject.getAsJsonArray("combinations"), GeneDiseaseCollectionJsonMemoryDeserializer.deserializeGenes(collectionObject.getAsJsonObject("ncbigene")), GeneDiseaseCollectionJsonMemoryDeserializer.deserializeDiseases(collectionObject.getAsJsonObject("umls")), GeneDiseaseCollectionJsonMemoryDeserializer.deserializeSources(collectionObject.getAsJsonObject("sources")));
    }

    private static GeneDiseaseCollection deserializeGeneDiseaseCollection(JsonArray combinationsArray, Map<String, Gene> genesMap, Map<String, Disease> diseasesMap, Map<String, Source> sourcesMap) {
        Iterator<JsonElement> combinationsIterator;
        GeneDiseaseCollection collection = new GeneDiseaseCollection();
        try {
            combinationsIterator = combinationsArray.iterator();
        }
        catch (NullPointerException e2) {
            throw new JsonParseException("Missing GeneDiseaseCombinations.");
        }
        while (combinationsIterator.hasNext()) {
            collection.add(GeneDiseaseCollectionJsonMemoryDeserializer.deserializeGeneDiseaseCombination(combinationsIterator.next().getAsJsonObject(), genesMap, diseasesMap, sourcesMap));
        }
        return collection;
    }

    private static Map<String, Gene> deserializeGenes(JsonObject jsonObject) {
        HashMap<String, Gene> genesMap = new HashMap<String, Gene>();
        if (jsonObject != null) {
            for (String geneId : jsonObject.keySet()) {
                genesMap.put(geneId, GeneDiseaseCollectionJsonMemoryDeserializer.deserializeGene(jsonObject.getAsJsonObject(geneId), geneId));
            }
        }
        return genesMap;
    }

    private static Map<String, Disease> deserializeDiseases(JsonObject jsonObject) {
        HashMap<String, Disease> diseasesMap = new HashMap<String, Disease>();
        if (jsonObject != null) {
            for (String diseaseId : jsonObject.keySet()) {
                diseasesMap.put(diseaseId, GeneDiseaseCollectionJsonMemoryDeserializer.deserializeDisease(jsonObject.getAsJsonObject(diseaseId), diseaseId));
            }
        }
        return diseasesMap;
    }

    private static Map<String, Source> deserializeSources(JsonObject jsonObject) {
        HashMap<String, Source> sourcesMap = new HashMap<String, Source>();
        if (jsonObject != null) {
            for (String sourceName : jsonObject.keySet()) {
                sourcesMap.put(sourceName, GeneDiseaseCollectionJsonMemoryDeserializer.deserializeSource(jsonObject.getAsJsonObject(sourceName), sourceName));
            }
        }
        return sourcesMap;
    }
}

