/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.GeneDiseaseCombination;
import org.molgenis.vibe.core.formats.Source;
import org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection.GeneDiseaseCollectionJsonSerializer;

public class GeneDiseaseCollectionJsonMemorySerializer
extends GeneDiseaseCollectionJsonSerializer
implements JsonSerializer<GeneDiseaseCollection> {
    @Override
    public JsonElement serialize(GeneDiseaseCollection src, Type typeOfSrc, JsonSerializationContext context2) {
        HashSet<Source> sources = new HashSet<Source>();
        JsonObject collectionObject = new JsonObject();
        collectionObject.add("ncbigene", GeneDiseaseCollectionJsonMemorySerializer.serializeGenes(src));
        collectionObject.add("umls", GeneDiseaseCollectionJsonMemorySerializer.serializeDiseases(src));
        JsonArray geneDiseaseCombinations = GeneDiseaseCollectionJsonMemorySerializer.serializeGeneDiseaseCombinations(src, sources);
        collectionObject.add("sources", GeneDiseaseCollectionJsonMemorySerializer.serializeSources(sources));
        collectionObject.add("combinations", geneDiseaseCombinations);
        return collectionObject;
    }

    private static JsonArray serializeGeneDiseaseCombinations(GeneDiseaseCollection src, Set<Source> foundSources) {
        JsonArray combinationsArray = new JsonArray();
        for (GeneDiseaseCombination gdc : src.getGeneDiseaseCombinationsOrdered()) {
            combinationsArray.add(GeneDiseaseCollectionJsonMemorySerializer.serializeGeneDiseaseCombination(gdc, foundSources));
        }
        return combinationsArray;
    }

    private static JsonObject serializeGenes(GeneDiseaseCollection src) {
        JsonObject genesObject = new JsonObject();
        for (Gene gene : src.getGenes()) {
            genesObject.add(gene.getId(), GeneDiseaseCollectionJsonMemorySerializer.serializeGene(gene));
        }
        return genesObject;
    }

    private static JsonObject serializeDiseases(GeneDiseaseCollection src) {
        JsonObject diseasesObject = new JsonObject();
        for (Disease disease : src.getDiseases()) {
            diseasesObject.add(disease.getId(), GeneDiseaseCollectionJsonMemorySerializer.serializeDisease(disease));
        }
        return diseasesObject;
    }

    private static JsonObject serializeSources(Set<Source> sourcesSet) {
        JsonObject sourcesObject = new JsonObject();
        for (Source source : sourcesSet) {
            sourcesObject.add(source.getName(), GeneDiseaseCollectionJsonMemorySerializer.serializeSource(source));
        }
        return sourcesObject;
    }
}

