/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCombination;
import org.molgenis.vibe.core.formats.PubmedEvidence;
import org.molgenis.vibe.core.formats.Source;
import org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection.GeneDiseaseCollectionJsonSerialization;

abstract class GeneDiseaseCollectionJsonSerializer
extends GeneDiseaseCollectionJsonSerialization {
    GeneDiseaseCollectionJsonSerializer() {
    }

    static JsonObject serializeGeneDiseaseCombination(GeneDiseaseCombination gdc) {
        return GeneDiseaseCollectionJsonSerializer.serializeGeneDiseaseCombination(gdc, new HashSet<Source>());
    }

    static JsonObject serializeGeneDiseaseCombination(GeneDiseaseCombination gdc, Set<Source> foundSources) {
        JsonObject combinationObject = new JsonObject();
        combinationObject.addProperty("ncbigene", gdc.getGene().getId());
        combinationObject.addProperty("umls", gdc.getDisease().getId());
        if (gdc.getDisgenetScore() != null) {
            combinationObject.addProperty("score", gdc.getDisgenetScore());
        }
        JsonArray evidenceArray = new JsonArray();
        ArrayList<Source> orderedSources = new ArrayList<Source>();
        orderedSources.addAll(gdc.getSourcesCount().keySet());
        Collections.sort(orderedSources);
        for (Source source : orderedSources) {
            foundSources.add(source);
            JsonObject evidenceItemObject = new JsonObject();
            evidenceItemObject.addProperty("name", source.getName());
            evidenceItemObject.addProperty("count", gdc.getCountForSource(source));
            JsonArray pubmedEvidenceArray = new JsonArray();
            List<PubmedEvidence> evidenceList = gdc.getPubmedEvidenceForSourceSortedByReleaseDate(source);
            if (evidenceList != null) {
                for (PubmedEvidence pubmedEvidence : evidenceList) {
                    JsonObject pubmedEvidenceObject = new JsonObject();
                    pubmedEvidenceObject.addProperty("uri", pubmedEvidence.getUri().toString());
                    pubmedEvidenceObject.addProperty("year", pubmedEvidence.getReleaseYear());
                    pubmedEvidenceArray.add(pubmedEvidenceObject);
                }
            }
            evidenceItemObject.add("pubmed", pubmedEvidenceArray);
            evidenceArray.add(evidenceItemObject);
        }
        combinationObject.add("sources", evidenceArray);
        return combinationObject;
    }

    static JsonObject serializeGene(Gene gene) {
        JsonObject singleGeneObject = new JsonObject();
        singleGeneObject.addProperty("hgnc", gene.getSymbol().getId());
        return singleGeneObject;
    }

    static JsonObject serializeDisease(Disease disease) {
        JsonObject singleDiseaseObject = new JsonObject();
        singleDiseaseObject.addProperty("name", disease.getName());
        return singleDiseaseObject;
    }

    static JsonObject serializeSource(Source source) {
        JsonObject singleSourceObject = new JsonObject();
        singleSourceObject.addProperty("fullName", source.getFullName());
        singleSourceObject.addProperty("uri", source.getUri().toString());
        singleSourceObject.addProperty("level", source.getLevel().getReadableString());
        return singleSourceObject;
    }
}

