/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.molgenis.vibe.core.exceptions.JsonIOParseException;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.Source;
import org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection.GeneDiseaseCollectionJsonDeserializer;

public class GeneDiseaseCollectionJsonStreamDeserializer
extends GeneDiseaseCollectionJsonDeserializer
implements Closeable {
    private JsonReader reader;

    private static String retrieveValidatedNextName(JsonReader reader, String expectedName) throws IOException {
        String actualName = reader.nextName();
        if (!actualName.equals(expectedName)) {
            throw new JsonParseException("JsonToken does not match the expected name. Expected \"" + expectedName + "\" but was \"" + actualName + "\"");
        }
        return actualName;
    }

    public GeneDiseaseCollectionJsonStreamDeserializer(InputStream inputStream) {
        this.reader = new JsonReader(new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8));
    }

    public GeneDiseaseCollection readJsonStream() throws IOException {
        try {
            return this.readCollectionStream();
        }
        catch (JsonParseException | IllegalStateException e2) {
            throw new JsonIOParseException(e2);
        }
    }

    private GeneDiseaseCollection readCollectionStream() throws IOException {
        GeneDiseaseCollection gdc = new GeneDiseaseCollection();
        this.reader.beginObject();
        GeneDiseaseCollectionJsonStreamDeserializer.retrieveValidatedNextName(this.reader, "ncbigene");
        Map<String, Gene> genesMap = this.readGenesStream();
        GeneDiseaseCollectionJsonStreamDeserializer.retrieveValidatedNextName(this.reader, "umls");
        Map<String, Disease> diseasesMap = this.readDiseasesStream();
        GeneDiseaseCollectionJsonStreamDeserializer.retrieveValidatedNextName(this.reader, "sources");
        Map<String, Source> sourcesMap = this.readSourcesStream();
        GeneDiseaseCollectionJsonStreamDeserializer.retrieveValidatedNextName(this.reader, "combinations");
        this.readCombinationsStream(gdc, genesMap, diseasesMap, sourcesMap);
        this.reader.endObject();
        return gdc;
    }

    private Map<String, Gene> readGenesStream() throws IOException {
        JsonMapCollector<Gene> digester = new JsonMapCollector<Gene>(this.reader){

            @Override
            protected void digestObject(Map entityMap, JsonObject jsonObject, String objectId) {
                entityMap.put(objectId, GeneDiseaseCollectionJsonDeserializer.deserializeGene(jsonObject, objectId));
            }
        };
        return digester.readStream();
    }

    private Map<String, Disease> readDiseasesStream() throws IOException {
        JsonMapCollector<Disease> digester = new JsonMapCollector<Disease>(this.reader){

            @Override
            protected void digestObject(Map<String, Disease> entityMap, JsonObject jsonObject, String objectId) {
                entityMap.put(objectId, GeneDiseaseCollectionJsonDeserializer.deserializeDisease(jsonObject, objectId));
            }
        };
        return digester.readStream();
    }

    private Map<String, Source> readSourcesStream() throws IOException {
        JsonMapCollector<Source> digester = new JsonMapCollector<Source>(this.reader){

            @Override
            protected void digestObject(Map<String, Source> entityMap, JsonObject jsonObject, String objectId) {
                entityMap.put(objectId, GeneDiseaseCollectionJsonDeserializer.deserializeSource(jsonObject, objectId));
            }
        };
        return digester.readStream();
    }

    private void readCombinationsStream(GeneDiseaseCollection gdc, Map<String, Gene> genesMap, Map<String, Disease> diseasesMap, Map<String, Source> sourcesMap) throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            gdc.add(GeneDiseaseCollectionJsonStreamDeserializer.deserializeGeneDiseaseCombination(JsonParser.parseReader(this.reader).getAsJsonObject(), genesMap, diseasesMap, sourcesMap));
        }
        this.reader.endArray();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private abstract class JsonMapCollector<T> {
        JsonReader reader;

        public JsonMapCollector(JsonReader reader) {
            this.reader = Objects.requireNonNull(reader);
        }

        protected Map<String, T> readStream() throws IOException {
            HashMap entityMap = new HashMap();
            this.reader.beginObject();
            while (this.reader.hasNext()) {
                String name = this.reader.nextName();
                JsonObject jsonObject = JsonParser.parseReader(this.reader).getAsJsonObject();
                this.digestObject(entityMap, jsonObject, name);
            }
            this.reader.endObject();
            return entityMap;
        }

        protected abstract void digestObject(Map<String, T> var1, JsonObject var2, String var3);
    }
}

