/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.GeneDiseaseCombination;
import org.molgenis.vibe.core.formats.Source;
import org.molgenis.vibe.core.formats.serialization.json.gene_disease_collection.GeneDiseaseCollectionJsonSerializer;

public class GeneDiseaseCollectionJsonStreamSerializer
extends GeneDiseaseCollectionJsonSerializer
implements Closeable {
    private Gson gson;
    private JsonWriter writer;

    public GeneDiseaseCollectionJsonStreamSerializer(Gson gson, OutputStream outputStream) throws IOException {
        this.gson = Objects.requireNonNull(gson);
        this.writer = this.gson.newJsonWriter(new OutputStreamWriter(Objects.requireNonNull(outputStream), StandardCharsets.UTF_8));
    }

    public void writeJsonStream(GeneDiseaseCollection collection) throws IOException {
        this.writer.beginObject();
        this.writeGenesStream(collection);
        this.writeDiseasesStream(collection);
        this.writeSourcesStream(collection);
        this.writeCombinationsStream(collection);
        this.writer.endObject();
    }

    private void writeGenesStream(GeneDiseaseCollection collection) throws IOException {
        this.writer.name("ncbigene");
        this.writer.beginObject();
        for (Gene gene : collection.getGenes()) {
            this.writer.name(gene.getId());
            this.gson.toJson((JsonElement)GeneDiseaseCollectionJsonStreamSerializer.serializeGene(gene), this.writer);
        }
        this.writer.endObject();
    }

    private void writeDiseasesStream(GeneDiseaseCollection collection) throws IOException {
        this.writer.name("umls");
        this.writer.beginObject();
        for (Disease disease : collection.getDiseases()) {
            this.writer.name(disease.getId());
            this.gson.toJson((JsonElement)GeneDiseaseCollectionJsonStreamSerializer.serializeDisease(disease), this.writer);
        }
        this.writer.endObject();
    }

    private void writeSourcesStream(GeneDiseaseCollection collection) throws IOException {
        HashSet<Source> foundSources = new HashSet<Source>();
        this.writer.name("sources");
        this.writer.beginObject();
        for (GeneDiseaseCombination gdc : collection.getGeneDiseaseCombinationsOrdered()) {
            for (Source source : gdc.getSourcesCount().keySet()) {
                if (foundSources.contains(source)) continue;
                foundSources.add(source);
                this.writer.name(source.getName());
                this.gson.toJson((JsonElement)GeneDiseaseCollectionJsonStreamSerializer.serializeSource(source), this.writer);
            }
        }
        this.writer.endObject();
    }

    private void writeCombinationsStream(GeneDiseaseCollection collection) throws IOException {
        this.writer.name("combinations");
        this.writer.beginArray();
        for (GeneDiseaseCombination gdc : collection.getGeneDiseaseCombinationsOrdered()) {
            this.gson.toJson((JsonElement)GeneDiseaseCollectionJsonStreamSerializer.serializeGeneDiseaseCombination(gdc), this.writer);
        }
        this.writer.endArray();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

