/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.ontology_processing;

import java.util.Collection;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.formats.PhenotypeNetwork;
import org.molgenis.vibe.core.ontology_processing.PhenotypesRetriever;

public class ChildrenRetriever
extends PhenotypesRetriever {
    public ChildrenRetriever(OntModel model, Collection<Phenotype> inputPhenotypes, int maxDistance) {
        super(model, inputPhenotypes, maxDistance);
    }

    @Override
    public void run() {
        for (Phenotype phenotype : this.getInputPhenotypes()) {
            PhenotypeNetwork network = new PhenotypeNetwork(phenotype);
            this.traverse(this.retrievePhenotypeFromModel(phenotype), network, 0);
            this.getPhenotypeNetworkCollection().add(network);
        }
    }

    private void traverse(OntClass phenotypeOC, PhenotypeNetwork network, int distance) {
        this.addPhenotypeToNetwork(phenotypeOC, network, distance);
        int nextDistance = distance + 1;
        if (nextDistance <= this.getMaxDistance()) {
            ExtendedIterator<OntClass> it = phenotypeOC.listSubClasses();
            while (it.hasNext()) {
                OntClass nextOC = (OntClass)it.next();
                this.traverse(nextOC, network, nextDistance);
            }
        }
    }
}

