/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;

public class Bitmap64 {
    protected static final int LOGW = 6;
    protected static final int W = 64;
    protected long numbits;
    protected long[] words;

    public Bitmap64() {
        this(64L);
    }

    public Bitmap64(long nbits) {
        this.numbits = 0L;
        this.words = new long[(int)Bitmap64.numWords(nbits)];
    }

    public Bitmap64(Bitmap64 other) {
        this(other, other.getNumBits());
    }

    public Bitmap64(Bitmap64 other, long numbits) {
        this.numbits = numbits;
        this.words = new long[(int)Bitmap64.numWords(numbits)];
        if (this.words.length > 0) {
            this.words[this.words.length - 1] = 0L;
        }
        System.arraycopy(other.words, 0, this.words, 0, this.words.length);
    }

    protected static int wordIndex(long bitIndex) {
        return (int)(bitIndex >>> 6);
    }

    public static long numWords(long numbits) {
        return (numbits - 1L >>> 6) + 1L;
    }

    public static long numBytes(long numbits) {
        return (numbits - 1L >>> 3) + 1L;
    }

    protected static int lastWordNumBits(long numbits) {
        if (numbits == 0L) {
            return 0;
        }
        return (int)((numbits - 1L) % 64L) + 1;
    }

    protected final void ensureSize(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            long[] newWords = new long[Math.max(this.words.length * 2, wordsRequired)];
            System.arraycopy(this.words, 0, newWords, 0, Math.min(this.words.length, newWords.length));
            this.words = newWords;
        }
    }

    public void trim(long numbits) {
        this.numbits = numbits;
    }

    public void trimToSize() {
        int wordNum = (int)Bitmap64.numWords(this.numbits);
        if (wordNum != this.words.length) {
            this.words = Arrays.copyOf(this.words, wordNum);
        }
    }

    public boolean access(long bitIndex) {
        if (bitIndex < 0L) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = Bitmap64.wordIndex(bitIndex);
        if (wordIndex >= this.words.length) {
            return false;
        }
        return (this.words[wordIndex] & 1L << (int)bitIndex) != 0L;
    }

    public void append(boolean value) {
        this.set(this.numbits++, value);
    }

    public void set(long bitIndex, boolean value) {
        if (bitIndex < 0L) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = Bitmap64.wordIndex(bitIndex);
        this.ensureSize(wordIndex + 1);
        if (value) {
            int n = wordIndex;
            this.words[n] = this.words[n] | 1L << (int)bitIndex;
        } else {
            int n = wordIndex;
            this.words[n] = this.words[n] & (1L << (int)bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.numbits = Math.max(this.numbits, bitIndex + 1L);
    }

    public long selectPrev1(long start) {
        throw new NotImplementedException();
    }

    public long selectNext1(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int wordIndex = Bitmap64.wordIndex(fromIndex);
        if (wordIndex >= this.words.length) {
            return -1L;
        }
        long word = this.words[wordIndex] & -1L << (int)fromIndex;
        while (word == 0L) {
            if (++wordIndex == this.words.length) {
                return -1L;
            }
            word = this.words[wordIndex];
        }
        return (long)wordIndex * 64L + (long)Long.numberOfTrailingZeros(word);
    }

    public long getWord(int word) {
        return this.words[word];
    }

    public long getNumBits() {
        return this.numbits;
    }

    public long getSizeBytes() {
        return Bitmap64.numWords(this.numbits) * 8L;
    }

    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(1);
        VByte.encode(out, this.numbits);
        out.writeCRC();
        out.setCRC(new CRC32());
        int numwords = (int)Bitmap64.numWords(this.numbits);
        for (int i = 0; i < numwords - 1; ++i) {
            IOUtil.writeLong(out, this.words[i]);
        }
        if (numwords > 0) {
            int lastWordUsed = Bitmap64.lastWordNumBits(this.numbits);
            BitUtil.writeLowerBitsByteAligned(this.words[numwords - 1], lastWordUsed, out);
        }
        out.writeCRC();
    }

    public void load(InputStream input, ProgressListener listener) throws IOException {
        CRCInputStream in = new CRCInputStream(input, new CRC8());
        int type = in.read();
        if (type != 1) {
            throw new IllegalArgumentException("Trying to read BitmapPlain on a section that is not BitmapPlain");
        }
        this.numbits = VByte.decode(in);
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Bitmap64 header.");
        }
        in.setCRC(new CRC32());
        int numwords = (int)Bitmap64.numWords(this.numbits);
        this.words = new long[numwords];
        for (int i = 0; i < numwords - 1; ++i) {
            this.words[i] = IOUtil.readLong(in);
        }
        if (numwords > 0) {
            int lastWordUsedBits = Bitmap64.lastWordNumBits(this.numbits);
            this.words[numwords - 1] = BitUtil.readLowerBitsByteAligned(lastWordUsedBits, in);
        }
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Bitmap64 data.");
        }
    }

    public String toString() {
        StringBuilder str2 = new StringBuilder();
        for (long i = 0L; i < this.numbits; ++i) {
            str2.append(this.access(i) ? (char)'1' : '0');
        }
        return str2.toString();
    }

    public long getRealSizeBytes() {
        return this.words.length * 8;
    }
}

