/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.sequence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.DynamicSequence;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;

public class SequenceLog64
implements DynamicSequence {
    protected static final byte W = 64;
    protected long[] data;
    protected int numbits;
    protected long numentries = 0L;
    protected long maxvalue;

    public SequenceLog64() {
        this(64);
    }

    public SequenceLog64(int numbits) {
        this(numbits, 0L);
    }

    public SequenceLog64(int numbits, long capacity) {
        this.numbits = numbits;
        this.maxvalue = BitUtil.maxVal(numbits);
        long size = SequenceLog64.numWordsFor(numbits, capacity);
        assert (size >= 0L);
        this.data = new long[Math.max((int)size, 1)];
    }

    public SequenceLog64(int numbits, long capacity, boolean initialize) {
        this(numbits, capacity);
        if (initialize) {
            this.numentries = capacity;
        }
    }

    public static long numWordsFor(int bitsField, long total) {
        return ((long)bitsField * total + 63L) / 64L;
    }

    public static int lastWordNumBits(int bitsField, long total) {
        long totalBits = (long)bitsField * total;
        if (totalBits == 0L) {
            return 0;
        }
        return (int)((totalBits - 1L) % 64L) + 1;
    }

    public static int lastWordNumBytes(int bitsField, long total) {
        return (SequenceLog64.lastWordNumBits(bitsField, total) - 1) / 8 + 1;
    }

    public static long numBytesFor(int bitsField, long total) {
        return ((long)bitsField * total + 7L) / 8L;
    }

    private static long getField(long[] data, int bitsField, long index) {
        long result;
        if (bitsField == 0) {
            return 0L;
        }
        long bitPos = index * (long)bitsField;
        int i = (int)(bitPos / 64L);
        int j = (int)(bitPos % 64L);
        if (j + bitsField <= 64) {
            result = data[i] << 64 - j - bitsField >>> 64 - bitsField;
        } else {
            result = data[i] >>> j;
            result |= data[i + 1] << 128 - j - bitsField >>> 64 - bitsField;
        }
        return result;
    }

    private static void setField(long[] data, int bitsField, long index, long value) {
        if (bitsField == 0) {
            return;
        }
        long bitPos = index * (long)bitsField;
        int i = (int)(bitPos / 64L);
        int j = (int)(bitPos % 64L);
        long mask = (-1L << bitsField ^ 0xFFFFFFFFFFFFFFFFL) << j;
        data[i] = data[i] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value << j;
        if (j + bitsField > 64) {
            mask = -1L << bitsField + j - 64;
            data[i + 1] = data[i + 1] & mask | value >>> 64 - j;
        }
    }

    private void resizeArray(int size) {
        this.data = Arrays.copyOf(this.data, size);
    }

    @Override
    public void add(Iterator<Long> elements) {
        long max2 = 0L;
        this.numentries = 0L;
        while (elements.hasNext()) {
            long val = elements.next();
            max2 = val > max2 ? val : max2;
            ++this.numentries;
        }
        this.numbits = BitUtil.log2(max2);
        int size = (int)SequenceLog64.numWordsFor(this.numbits, this.numentries);
        this.data = new long[size];
        int count = 0;
        while (elements.hasNext()) {
            long element = elements.next();
            assert (element <= this.maxvalue);
            SequenceLog64.setField(this.data, this.numbits, count, element);
            ++count;
        }
    }

    public void addIntegers(List<Integer> elements) {
        long max2 = 0L;
        this.numentries = 0L;
        for (int i = 0; i < elements.size(); ++i) {
            long val = elements.get(i).longValue();
            max2 = val > max2 ? val : max2;
            ++this.numentries;
        }
        this.numbits = BitUtil.log2(max2);
        int size = (int)SequenceLog64.numWordsFor(this.numbits, this.numentries);
        this.data = new long[size];
        int count = 0;
        for (int i = 0; i < elements.size(); ++i) {
            long element = elements.get(i).longValue();
            assert (element <= this.maxvalue);
            SequenceLog64.setField(this.data, this.numbits, count, element);
            ++count;
        }
    }

    @Override
    public long get(long position) {
        if (position < 0L || position >= this.numentries) {
            throw new IndexOutOfBoundsException();
        }
        return SequenceLog64.getField(this.data, this.numbits, position);
    }

    @Override
    public void set(long position, long value) {
        if (value < 0L || value > this.maxvalue) {
            throw new IllegalArgumentException("Value exceeds the maximum for this data structure");
        }
        SequenceLog64.setField(this.data, this.numbits, position, value);
    }

    @Override
    public void append(long value) {
        if (value < 0L || value > this.maxvalue) {
            throw new IllegalArgumentException("Value exceeds the maximum for this data structure");
        }
        long neededSize = SequenceLog64.numWordsFor(this.numbits, this.numentries + 1L);
        if ((long)this.data.length < neededSize) {
            this.resizeArray(this.data.length * 2);
        }
        this.set((int)this.numentries, value);
        ++this.numentries;
    }

    @Override
    public void aggressiveTrimToSize() {
        long max2 = 0L;
        int i = 0;
        while ((long)i < this.numentries) {
            long value = this.get(i);
            max2 = value > max2 ? value : max2;
            ++i;
        }
        int newbits = BitUtil.log2(max2);
        assert (newbits <= this.numbits);
        if (newbits != this.numbits) {
            int i2 = 0;
            while ((long)i2 < this.numentries) {
                long value = SequenceLog64.getField(this.data, this.numbits, i2);
                SequenceLog64.setField(this.data, newbits, i2, value);
                ++i2;
            }
            this.numbits = newbits;
            this.maxvalue = BitUtil.maxVal(this.numbits);
            long totalSize = SequenceLog64.numWordsFor(this.numbits, this.numentries);
            this.resizeArray((int)totalSize);
        }
    }

    @Override
    public void trimToSize() {
        this.resizeArray((int)SequenceLog64.numWordsFor(this.numbits, this.numentries));
    }

    public void resize(long numentries) {
        this.numentries = numentries;
        this.resizeArray((int)SequenceLog64.numWordsFor(this.numbits, numentries));
    }

    @Override
    public long getNumberOfElements() {
        return this.numentries;
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(1);
        out.write(this.numbits);
        VByte.encode(out, this.numentries);
        out.writeCRC();
        out.setCRC(new CRC32());
        int numwords = (int)SequenceLog64.numWordsFor(this.numbits, this.numentries);
        for (int i = 0; i < numwords - 1; ++i) {
            IOUtil.writeLong(out, this.data[i]);
        }
        if (numwords > 0) {
            int lastWordUsedBits = SequenceLog64.lastWordNumBits(this.numbits, this.numentries);
            BitUtil.writeLowerBitsByteAligned(this.data[numwords - 1], lastWordUsedBits, out);
        }
        out.writeCRC();
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        CRCInputStream in = new CRCInputStream(input, new CRC8());
        int type = in.read();
        if (type != 1) {
            throw new IllegalFormatException("Trying to read a LogArray but the data is not LogArray");
        }
        this.numbits = in.read();
        this.numentries = VByte.decode(in);
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading LogArray64 header.");
        }
        if (this.numbits > 64) {
            throw new IllegalFormatException("LogArray64 cannot deal with more than 64bit per entry");
        }
        in.setCRC(new CRC32());
        int numwords = (int)SequenceLog64.numWordsFor(this.numbits, this.numentries);
        this.data = new long[numwords];
        for (int i = 0; i < numwords - 1; ++i) {
            this.data[i] = IOUtil.readLong(in);
        }
        if (numwords > 0) {
            int lastWordUsed = SequenceLog64.lastWordNumBits(this.numbits, this.numentries);
            this.data[numwords - 1] = BitUtil.readLowerBitsByteAligned(lastWordUsed, in);
        }
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading LogArray64 data.");
        }
    }

    @Override
    public long size() {
        return SequenceLog64.numBytesFor(this.numbits, this.numentries);
    }

    public long getRealSize() {
        return (long)this.data.length * 8L;
    }

    public int getNumBits() {
        return this.numbits;
    }

    @Override
    public String getType() {
        return "<http://purl.org/HDT/hdt#seqLog>";
    }

    public long binSearchExact(long element, long begin, long end) throws NotFoundException {
        while (begin <= end) {
            long mid = (begin + end) / 2L;
            long read = this.get(mid);
            if (element > read) {
                begin = mid + 1L;
                continue;
            }
            if (element < read) {
                end = mid - 1L;
                continue;
            }
            return mid;
        }
        throw new NotFoundException();
    }

    public long binSearch(long element, long fromIndex, long toIndex) {
        long low = fromIndex;
        long high = toIndex - 1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            long midVal = this.get(mid);
            if (midVal < element) {
                low = mid + 1L;
                continue;
            }
            if (midVal > element) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    @Override
    public void close() throws IOException {
        this.data = null;
    }
}

