/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.CompactString;

public class HashDictionarySection
implements TempDictionarySection {
    public static final int TYPE_INDEX = 1;
    private HashMap<CharSequence, Long> map = new HashMap();
    private List<CharSequence> list = new ArrayList<CharSequence>();
    private int size = 0;
    boolean sorted;

    public HashDictionarySection() {
        this(new HDTSpecification());
    }

    public HashDictionarySection(HDTOptions spec) {
    }

    @Override
    public long locate(CharSequence s) {
        CompactString compact = new CompactString(s);
        Long val = this.map.get(compact);
        if (val == null) {
            return 0L;
        }
        return val;
    }

    @Override
    public CharSequence extract(long pos) {
        if (pos <= 0L) {
            return null;
        }
        return this.list.get((int)(pos - 1L));
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long getNumberOfElements() {
        return this.list.size();
    }

    @Override
    public Iterator<? extends CharSequence> getSortedEntries() {
        if (!this.sorted) {
            return null;
        }
        return this.list.iterator();
    }

    @Override
    public Iterator<? extends CharSequence> getEntries() {
        return this.list.iterator();
    }

    @Override
    public long add(CharSequence entry) {
        CompactString compact = new CompactString(entry);
        Long pos = this.map.get(compact);
        if (pos != null) {
            return pos;
        }
        this.list.add(compact);
        this.map.put(compact, Long.valueOf(this.list.size()));
        this.size += compact.length();
        this.sorted = false;
        return this.list.size();
    }

    @Override
    public void remove(CharSequence seq2) {
        this.map.remove(seq2);
        this.sorted = false;
    }

    @Override
    public void sort() {
        this.list = new ArrayList<CharSequence>(this.map.size());
        for (CharSequence str2 : this.map.keySet()) {
            this.list.add(str2);
        }
        Collections.sort(this.list, new CharSequenceComparator());
        for (long i = 1L; i <= this.getNumberOfElements(); ++i) {
            this.map.put(this.extract(i), i);
        }
        this.sorted = true;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.map.clear();
        this.size = 0;
        this.sorted = false;
    }

    @Override
    public void close() throws IOException {
        this.map = null;
        this.list = null;
    }
}

