/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Comparator;
import java.util.Iterator;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.iterator.utils.Reducer;

public class MergedReduceIterator<T>
implements Iterator<T> {
    private final Iterator<T> left;
    private final Iterator<T> right;
    private T currentLeft;
    private T currentRight;
    private final Comparator<T> comparator;
    private final Reducer<T> reducer;

    public MergedReduceIterator(Iterator<T> left, Iterator<T> right, Comparator<T> comparator, Reducer<T> combinator) {
        this.left = left;
        this.right = right;
        this.comparator = comparator;
        this.reducer = combinator;
        this.advanceLeft();
        this.advanceRight();
    }

    @Override
    public boolean hasNext() {
        return this.currentLeft != null || this.currentRight != null;
    }

    private T advanceLeft() {
        T tmp = this.currentLeft;
        this.currentLeft = this.left.hasNext() ? this.left.next() : null;
        return tmp;
    }

    private T advanceRight() {
        T tmp = this.currentRight;
        this.currentRight = this.right.hasNext() ? this.right.next() : null;
        return tmp;
    }

    @Override
    public T next() {
        if (this.currentLeft != null && this.currentRight == null) {
            return this.advanceLeft();
        }
        if (this.currentLeft == null && this.currentRight != null) {
            return this.advanceRight();
        }
        int cmp = this.comparator.compare(this.currentLeft, this.currentRight);
        if (cmp == 0) {
            return this.reducer.reduce(this.advanceLeft(), this.advanceRight());
        }
        if (cmp > 0) {
            return this.advanceLeft();
        }
        return this.advanceRight();
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }
}

