/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.crc;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.rdfhdt.hdt.util.crc.CRC;

public class CRCOutputStream
extends FilterOutputStream {
    protected CRC crc;

    public CRCOutputStream(OutputStream out, CRC crc) {
        super(out);
        this.crc = crc;
    }

    public void setCRC(CRC crc) {
        this.crc = crc;
    }

    public CRC getCRC() {
        return this.crc;
    }

    public void writeCRC() throws IOException {
        this.crc.writeCRC(this.out);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.crc.update(b, 0, b.length);
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.crc.update(b, off, len);
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.crc.update((byte)(b & 0xFF));
        this.out.write(b);
    }
}

