/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountOutputStream
extends FilterOutputStream {
    long total = 0L;
    long partial = 0L;

    public CountOutputStream(OutputStream parent) {
        super(parent);
    }

    public long getTotalBytes() {
        return this.total;
    }

    public long getPartialBytes() {
        return this.partial;
    }

    public void resetPartial() {
        this.partial = 0L;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.total;
        ++this.partial;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.partial += (long)b.length;
        this.total += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.partial += (long)len;
        this.total += (long)len;
    }
}

