/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.solver;

import java.util.List;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphMapLink;
import org.apache.jena.sparql.core.DatasetGraphOne;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.PlanOp;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterYieldN;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.AggCount;
import org.apache.jena.sparql.expr.aggregate.AggCountDistinct;
import org.apache.jena.sparql.expr.aggregate.AggCountVar;
import org.apache.jena.sparql.expr.aggregate.AggCountVarDistinct;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.util.Context;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdtjena.HDTGraph;
import org.rdfhdt.hdtjena.solver.BindingOne;
import org.rdfhdt.hdtjena.solver.HDTOptimizedOp;
import org.rdfhdt.hdtjena.solver.HDTQueryEngine;

public class OptimizedCount {
    private OptimizedCount() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Plan getPlan(HDTQueryEngine engine, Query query, DatasetGraph dataset, Binding input, Context context2) {
        long count;
        ExprList exprList;
        if (query.getAggregators().size() != 1) {
            return null;
        }
        Aggregator ag = query.getAggregators().get(0).getAggregator();
        if (ag == null || !query.getHavingExprs().isEmpty() || !query.getGroupBy().isEmpty() || query.hasLimit() || query.hasOffset() || !(ag instanceof AggCount) && !(ag instanceof AggCountVar) && !(ag instanceof AggCountDistinct) && !(ag instanceof AggCountVarDistinct)) {
            return null;
        }
        ElementGroup el = (ElementGroup)query.getQueryPattern();
        List<Element> list = el.getElements();
        if (list.size() != 1) {
            return null;
        }
        Element ele = list.get(0);
        Node graphName = null;
        if (ele instanceof ElementNamedGraph) {
            graphName = ((ElementNamedGraph)ele).getGraphNameNode();
            if (graphName.isVariable()) {
                return null;
            }
            if ((ele = ((ElementNamedGraph)ele).getElement()) instanceof ElementGroup) {
                ElementGroup elGroup = (ElementGroup)ele;
                if (elGroup.getElements().size() != 1) {
                    return null;
                }
                ele = elGroup.getElements().get(0);
            }
        }
        if (!(ele instanceof ElementPathBlock)) {
            return null;
        }
        PathBlock pb = ((ElementPathBlock)ele).getPattern();
        if (pb.size() != 1) {
            return null;
        }
        TriplePath tp = pb.get(0);
        Triple triple = tp.asTriple();
        if (triple == null) {
            return null;
        }
        if (triple.getSubject().equals(triple.getPredicate()) || triple.getPredicate().equals(triple.getObject()) || triple.getSubject().equals(triple.getObject())) {
            return null;
        }
        if (query.getProjectVars().size() != 1) {
            return null;
        }
        Var varOutput = query.getProjectVars().get(0);
        Graph g = null;
        if (dataset instanceof DatasetGraphOne) {
            g = dataset.getDefaultGraph();
        } else if (dataset instanceof DatasetGraphMapLink) {
            g = graphName != null ? dataset.getGraph(graphName) : dataset.getDefaultGraph();
        }
        if (g == null || !(g instanceof HDTGraph)) {
            return null;
        }
        HDTGraph hdtg = (HDTGraph)g;
        if (ag instanceof AggCountVarDistinct) {
            exprList = ag.getExprList();
            if (exprList.size() != 1) {
                return null;
            }
            Expr expr = exprList.get(0);
            if (!(expr instanceof ExprVar)) {
                return null;
            }
            Var countVar = expr.asVar();
            if (!(triple.getSubject().isVariable() && triple.getPredicate().isVariable() && triple.getObject().isVariable())) {
                return null;
            }
            Dictionary dictionary = hdtg.getHDT().getDictionary();
            if (countVar.equals(triple.getSubject())) {
                count = dictionary.getNsubjects();
            } else if (countVar.equals(triple.getPredicate())) {
                count = dictionary.getNpredicates();
            } else {
                if (!countVar.equals(triple.getObject())) return null;
                count = dictionary.getNobjects();
            }
        } else {
            TripleID patternID;
            if (ag instanceof AggCountVar) {
                exprList = ag.getExprList();
                if (exprList.size() != 1) {
                    return null;
                }
                Expr expr = exprList.get(0);
                if (!(expr instanceof ExprVar)) {
                    return null;
                }
                Var countVar = expr.asVar();
                if (!(triple.getSubject().equals(countVar) || triple.getPredicate().equals(countVar) || triple.getObject().equals(countVar))) {
                    return null;
                }
            }
            if ((patternID = hdtg.getNodeDictionary().getTriplePatID(triple)).isEmpty()) {
                count = hdtg.getHDT().getTriples().getNumberOfElements();
            } else if (!patternID.isNoMatch()) {
                IteratorTripleID it = hdtg.getHDT().getTriples().search(patternID);
                if (it.numResultEstimation() == ResultEstimationType.EXACT) {
                    count = it.estimatedNumResults();
                } else {
                    count = 0L;
                    while (it.hasNext()) {
                        it.next();
                        ++count;
                    }
                }
            } else {
                count = 0L;
            }
        }
        BindingOne bindingResult = new BindingOne(varOutput, NodeFactory.createLiteral(Long.toString(count), XSDDatatype.XSDinteger));
        return new PlanOp(new HDTOptimizedOp(), engine, new QueryIterYieldN(1, bindingResult));
    }
}

